/*
 * Decompiled with CFR 0.152.
 */
package io.github.classgraph;

import io.github.classgraph.ClasspathElement;
import io.github.classgraph.ClasspathElementModule;
import io.github.classgraph.ModuleRef;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.nio.file.attribute.PosixFilePermission;
import java.util.Set;
import nonapi.io.github.classgraph.utils.FileUtils;
import nonapi.io.github.classgraph.utils.InputStreamOrByteBufferAdapter;
import nonapi.io.github.classgraph.utils.LogNode;
import nonapi.io.github.classgraph.utils.URLPathEncoder;

public abstract class Resource
implements Closeable,
Comparable<Resource> {
    private final ClasspathElement classpathElement;
    protected InputStream inputStream;
    protected ByteBuffer byteBuffer;
    protected long length;
    private boolean isOpen;
    private String toString;
    LogNode scanLog;

    public Resource(ClasspathElement classpathElement, long length) {
        this.classpathElement = classpathElement;
        this.length = length;
    }

    protected InputStream byteBufferToInputStream() {
        return this.inputStream == null ? (this.inputStream = FileUtils.byteBufferToInputStream(this.byteBuffer)) : this.inputStream;
    }

    protected ByteBuffer inputStreamToByteBuffer() throws IOException {
        return this.byteBuffer == null ? (this.byteBuffer = ByteBuffer.wrap(this.inputStreamToByteArray())) : this.byteBuffer;
    }

    protected byte[] inputStreamToByteArray() throws IOException {
        return FileUtils.readAllBytesAsArray(this.inputStream, this.length);
    }

    protected byte[] byteBufferToByteArray() {
        if (this.byteBuffer.hasArray()) {
            return this.byteBuffer.array();
        }
        byte[] byteArray = new byte[this.byteBuffer.remaining()];
        this.byteBuffer.get(byteArray);
        return byteArray;
    }

    protected void markAsOpen() throws IOException {
        if (this.isOpen) {
            throw new IOException("Resource is already open -- cannot open it again without first calling close()");
        }
        this.isOpen = true;
    }

    protected void markAsClosed() {
        this.isOpen = false;
    }

    private static URL uriToURL(URI uri) {
        if (uri.getScheme().equals("jrt")) {
            throw new IllegalArgumentException("Could not create URL from URI with \"jrt:\" scheme: " + uri);
        }
        try {
            return uri.toURL();
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Could not create URL from URI: " + uri + " -- " + e);
        }
    }

    public URI getURI() {
        URI locationURI = this.getClasspathElementURI();
        String locationURIStr = locationURI.toString();
        String resourcePath = this.getPathRelativeToClasspathElement();
        boolean isDir = locationURIStr.endsWith("/");
        try {
            return new URI((isDir || locationURIStr.startsWith("jar:") ? "" : "jar:") + locationURIStr + (isDir ? "" : "!/") + URLPathEncoder.encodePath(resourcePath));
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Could not form URL for classpath element: " + locationURIStr + " ; path: " + resourcePath + " : " + e);
        }
    }

    public URL getURL() {
        return Resource.uriToURL(this.getURI());
    }

    public URI getClasspathElementURI() {
        return this.classpathElement.getURI();
    }

    public URL getClasspathElementURL() {
        return Resource.uriToURL(this.getClasspathElementURI());
    }

    public File getClasspathElementFile() {
        return this.classpathElement.getFile();
    }

    public ModuleRef getModuleRef() {
        return this.classpathElement instanceof ClasspathElementModule ? ((ClasspathElementModule)this.classpathElement).moduleRef : null;
    }

    public String getContentAsString() throws IOException {
        try {
            String string = new String(this.load(), StandardCharsets.UTF_8);
            return string;
        }
        finally {
            this.close();
        }
    }

    public abstract String getPath();

    public abstract String getPathRelativeToClasspathElement();

    public abstract InputStream open() throws IOException;

    public abstract ByteBuffer read() throws IOException;

    public abstract byte[] load() throws IOException;

    abstract InputStreamOrByteBufferAdapter openOrRead() throws IOException;

    public long getLength() {
        return this.length;
    }

    public abstract long getLastModified();

    public abstract Set<PosixFilePermission> getPosixFilePermissions();

    public String toString() {
        if (this.toString != null) {
            return this.toString;
        }
        this.toString = this.getURI().toString();
        return this.toString;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Resource)) {
            return false;
        }
        return this.toString().equals(obj.toString());
    }

    @Override
    public int compareTo(Resource o) {
        return this.toString().compareTo(o.toString());
    }

    @Override
    public void close() {
        if (this.inputStream != null) {
            try {
                if (this.inputStream instanceof InputStreamResourceCloser) {
                    ((InputStreamResourceCloser)this.inputStream).closeInputStream();
                } else {
                    this.inputStream.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.inputStream = null;
        }
    }

    protected class InputStreamResourceCloser
    extends InputStream {
        private InputStream inputStream;
        private Resource parentResource;

        protected InputStreamResourceCloser(Resource parentResource, InputStream inputStream) throws IOException {
            if (inputStream == null) {
                throw new IOException("InputStream cannot be null");
            }
            this.inputStream = inputStream;
            this.parentResource = parentResource;
        }

        @Override
        public int read() throws IOException {
            if (this.inputStream == null) {
                throw new IOException("InputStream is not open");
            }
            return this.inputStream.read();
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            if (this.inputStream == null) {
                throw new IOException("InputStream is not open");
            }
            return this.inputStream.read(b, off, len);
        }

        @Override
        public int read(byte[] b) throws IOException {
            if (this.inputStream == null) {
                throw new IOException("InputStream is not open");
            }
            return this.inputStream.read(b);
        }

        @Override
        public int available() throws IOException {
            if (this.inputStream == null) {
                throw new IOException("InputStream is not open");
            }
            return this.inputStream.available();
        }

        @Override
        public long skip(long n) throws IOException {
            if (this.inputStream == null) {
                throw new IOException("InputStream is not open");
            }
            return this.inputStream.skip(n);
        }

        @Override
        public boolean markSupported() {
            return this.inputStream.markSupported();
        }

        @Override
        public synchronized void mark(int readlimit) {
            this.inputStream.mark(readlimit);
        }

        @Override
        public synchronized void reset() throws IOException {
            if (this.inputStream == null) {
                throw new IOException("InputStream is not open");
            }
            this.inputStream.reset();
        }

        void closeInputStream() throws IOException {
            if (this.inputStream != null) {
                try {
                    this.inputStream.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.inputStream = null;
            }
        }

        @Override
        public void close() throws IOException {
            if (this.parentResource != null) {
                this.parentResource.close();
                this.parentResource = null;
            }
        }
    }
}

