/*
 * Decompiled with CFR 0.152.
 */
package nonapi.io.github.classgraph.fastzipfilereader;

import io.github.classgraph.ClassGraphException;
import io.github.classgraph.ModuleReaderProxy;
import io.github.classgraph.ModuleRef;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import nonapi.io.github.classgraph.concurrency.InterruptionChecker;
import nonapi.io.github.classgraph.concurrency.SingletonMap;
import nonapi.io.github.classgraph.fastzipfilereader.FastZipEntry;
import nonapi.io.github.classgraph.fastzipfilereader.LogicalZipFile;
import nonapi.io.github.classgraph.fastzipfilereader.MappedByteBufferResources;
import nonapi.io.github.classgraph.fastzipfilereader.PhysicalZipFile;
import nonapi.io.github.classgraph.fastzipfilereader.RecyclableInflater;
import nonapi.io.github.classgraph.fastzipfilereader.ZipFileSlice;
import nonapi.io.github.classgraph.json.ReferenceEqualityKey;
import nonapi.io.github.classgraph.recycler.Recycler;
import nonapi.io.github.classgraph.scanspec.ScanSpec;
import nonapi.io.github.classgraph.utils.FastPathResolver;
import nonapi.io.github.classgraph.utils.FileUtils;
import nonapi.io.github.classgraph.utils.JarUtils;
import nonapi.io.github.classgraph.utils.LogNode;

public class NestedJarHandler {
    private final ScanSpec scanSpec;
    private SingletonMap<File, PhysicalZipFile, IOException> canonicalFileToPhysicalZipFileMap = new SingletonMap<File, PhysicalZipFile, IOException>(){

        @Override
        public PhysicalZipFile newInstance(File canonicalFile, LogNode log) throws IOException {
            if (NestedJarHandler.this.closed.get()) {
                throw ClassGraphException.newClassGraphException(NestedJarHandler.class.getSimpleName() + " already closed");
            }
            PhysicalZipFile physicalZipFile = new PhysicalZipFile(canonicalFile, NestedJarHandler.this);
            NestedJarHandler.this.allocatedPhysicalZipFiles.add(physicalZipFile);
            return physicalZipFile;
        }
    };
    private Queue<PhysicalZipFile> allocatedPhysicalZipFiles = new ConcurrentLinkedQueue<PhysicalZipFile>();
    private final Queue<LogicalZipFile> allocatedLogicalZipFiles = new ConcurrentLinkedQueue<LogicalZipFile>();
    private SingletonMap<FastZipEntry, ZipFileSlice, IOException> fastZipEntryToZipFileSliceMap = new SingletonMap<FastZipEntry, ZipFileSlice, IOException>(){

        @Override
        public ZipFileSlice newInstance(FastZipEntry childZipEntry, LogNode log) throws IOException, InterruptedException {
            ZipFileSlice childZipEntrySlice;
            if (!childZipEntry.isDeflated) {
                childZipEntrySlice = new ZipFileSlice(childZipEntry);
            } else {
                if (log != null) {
                    log.log("Deflating nested zip entry: " + childZipEntry + " ; uncompressed size: " + childZipEntry.uncompressedSize);
                }
                PhysicalZipFile physicalZipFile = new PhysicalZipFile(childZipEntry.open(), childZipEntry.entryName, NestedJarHandler.this, log);
                NestedJarHandler.this.allocatedPhysicalZipFiles.add(physicalZipFile);
                childZipEntrySlice = new ZipFileSlice(physicalZipFile, childZipEntry);
            }
            return childZipEntrySlice;
        }
    };
    private SingletonMap<ZipFileSlice, LogicalZipFile, IOException> zipFileSliceToLogicalZipFileMap = new SingletonMap<ZipFileSlice, LogicalZipFile, IOException>(){

        @Override
        public LogicalZipFile newInstance(ZipFileSlice zipFileSlice, LogNode log) throws IOException, InterruptedException {
            if (NestedJarHandler.this.closed.get()) {
                throw ClassGraphException.newClassGraphException(NestedJarHandler.class.getSimpleName() + " already closed");
            }
            LogicalZipFile logicalZipFile = new LogicalZipFile(zipFileSlice, log);
            NestedJarHandler.this.allocatedLogicalZipFiles.add(logicalZipFile);
            return logicalZipFile;
        }
    };
    public SingletonMap<String, Map.Entry<LogicalZipFile, String>, IOException> nestedPathToLogicalZipFileAndPackageRootMap = new SingletonMap<String, Map.Entry<LogicalZipFile, String>, IOException>(){

        @Override
        public Map.Entry<LogicalZipFile, String> newInstance(String nestedJarPathRaw, LogNode log) throws IOException, InterruptedException {
            LogicalZipFile childLogicalZipFile;
            ZipFileSlice childZipEntrySlice;
            Map.Entry<LogicalZipFile, String> parentLogicalZipFileAndPackageRoot;
            if (NestedJarHandler.this.closed.get()) {
                throw ClassGraphException.newClassGraphException(NestedJarHandler.class.getSimpleName() + " already closed");
            }
            String nestedJarPath = FastPathResolver.resolve(nestedJarPathRaw);
            int lastPlingIdx = nestedJarPath.lastIndexOf(33);
            if (lastPlingIdx < 0) {
                LogicalZipFile logicalZipFile;
                PhysicalZipFile physicalZipFile;
                boolean isURL = JarUtils.URL_SCHEME_PATTERN.matcher(nestedJarPath).matches();
                if (isURL) {
                    String scheme = nestedJarPath.substring(0, nestedJarPath.indexOf(58));
                    if (((NestedJarHandler)NestedJarHandler.this).scanSpec.allowedURLSchemes == null || !((NestedJarHandler)NestedJarHandler.this).scanSpec.allowedURLSchemes.contains(scheme)) {
                        throw new IOException("Scanning of URL scheme \"" + scheme + "\" has not been enabled -- cannot scan classpath element: " + nestedJarPath);
                    }
                    LogNode subLog = log == null ? null : log.log("Downloading jar from URL " + nestedJarPath);
                    physicalZipFile = NestedJarHandler.this.downloadJarFromURL(nestedJarPath, subLog);
                } else {
                    try {
                        File canonicalFile = new File(nestedJarPath).getCanonicalFile();
                        physicalZipFile = (PhysicalZipFile)NestedJarHandler.this.canonicalFileToPhysicalZipFileMap.get(canonicalFile, log);
                    }
                    catch (SingletonMap.NullSingletonException e) {
                        throw new IOException("Could not get PhysicalZipFile for path " + nestedJarPath + " : " + e);
                    }
                    catch (SecurityException e) {
                        throw new IOException("Path component " + nestedJarPath + " could not be canonicalized: " + e);
                    }
                }
                ZipFileSlice topLevelSlice = new ZipFileSlice(physicalZipFile);
                try {
                    logicalZipFile = (LogicalZipFile)NestedJarHandler.this.zipFileSliceToLogicalZipFileMap.get(topLevelSlice, log);
                }
                catch (SingletonMap.NullSingletonException e) {
                    throw new IOException("Could not get toplevel slice " + topLevelSlice + " : " + e);
                }
                return new AbstractMap.SimpleEntry<LogicalZipFile, String>(logicalZipFile, "");
            }
            String parentPath = nestedJarPath.substring(0, lastPlingIdx);
            String childPath = nestedJarPath.substring(lastPlingIdx + 1);
            childPath = FileUtils.sanitizeEntryPath(childPath, true);
            try {
                parentLogicalZipFileAndPackageRoot = NestedJarHandler.this.nestedPathToLogicalZipFileAndPackageRootMap.get(parentPath, log);
            }
            catch (SingletonMap.NullSingletonException e) {
                throw new IOException("Could not get parent logical zipfile " + parentPath + " : " + e);
            }
            LogicalZipFile parentLogicalZipFile = parentLogicalZipFileAndPackageRoot.getKey();
            boolean isDirectory = false;
            while (childPath.endsWith("/")) {
                isDirectory = true;
                childPath = childPath.substring(0, childPath.length() - 1);
            }
            FastZipEntry childZipEntry = null;
            if (!isDirectory) {
                for (FastZipEntry fastZipEntry : parentLogicalZipFile.entries) {
                    if (!fastZipEntry.entryName.equals(childPath)) continue;
                    childZipEntry = fastZipEntry;
                    break;
                }
            }
            if (childZipEntry == null) {
                String childPathPrefix = childPath + "/";
                for (FastZipEntry entry : parentLogicalZipFile.entries) {
                    if (!entry.entryName.startsWith(childPathPrefix)) continue;
                    isDirectory = true;
                    break;
                }
            }
            if (isDirectory) {
                if (!childPath.isEmpty()) {
                    if (log != null) {
                        log.log("Path " + childPath + " in jarfile " + parentLogicalZipFile + " is a directory, not a file -- using as package root");
                    }
                    parentLogicalZipFile.classpathRoots.add(childPath);
                }
                return new AbstractMap.SimpleEntry<LogicalZipFile, String>(parentLogicalZipFile, childPath);
            }
            if (childZipEntry == null) {
                throw new IOException("Path " + childPath + " does not exist in jarfile " + parentLogicalZipFile);
            }
            if (!((NestedJarHandler)NestedJarHandler.this).scanSpec.scanNestedJars) {
                throw new IOException("Nested jar scanning is disabled -- skipping nested jar " + nestedJarPath);
            }
            try {
                childZipEntrySlice = (ZipFileSlice)NestedJarHandler.this.fastZipEntryToZipFileSliceMap.get(childZipEntry, log);
            }
            catch (SingletonMap.NullSingletonException nullSingletonException) {
                throw new IOException("Could not get child zip entry slice " + childZipEntry + " : " + nullSingletonException);
            }
            LogNode logNode = log == null ? null : log.log("Getting zipfile slice " + childZipEntrySlice + " for nested jar " + childZipEntry.entryName);
            try {
                childLogicalZipFile = (LogicalZipFile)NestedJarHandler.this.zipFileSliceToLogicalZipFileMap.get(childZipEntrySlice, logNode);
            }
            catch (SingletonMap.NullSingletonException e) {
                throw new IOException("Could not get child logical zipfile " + childZipEntrySlice + " : " + e);
            }
            return new AbstractMap.SimpleEntry<LogicalZipFile, String>(childLogicalZipFile, "");
        }
    };
    public SingletonMap<ModuleRef, Recycler<ModuleReaderProxy, IOException>, IOException> moduleRefToModuleReaderProxyRecyclerMap = new SingletonMap<ModuleRef, Recycler<ModuleReaderProxy, IOException>, IOException>(){

        @Override
        public Recycler<ModuleReaderProxy, IOException> newInstance(final ModuleRef moduleRef, LogNode ignored) {
            return new Recycler<ModuleReaderProxy, IOException>(){

                @Override
                public ModuleReaderProxy newInstance() throws IOException {
                    if (NestedJarHandler.this.closed.get()) {
                        throw ClassGraphException.newClassGraphException(NestedJarHandler.class.getSimpleName() + " already closed");
                    }
                    return moduleRef.open();
                }
            };
        }
    };
    Recycler<RecyclableInflater, RuntimeException> inflaterRecycler = new Recycler<RecyclableInflater, RuntimeException>(){

        @Override
        public RecyclableInflater newInstance() throws RuntimeException {
            if (NestedJarHandler.this.closed.get()) {
                throw ClassGraphException.newClassGraphException(NestedJarHandler.class.getSimpleName() + " already closed");
            }
            return new RecyclableInflater();
        }
    };
    private Set<ReferenceEqualityKey<? extends ByteBuffer>> mappedByteBuffers = Collections.newSetFromMap(new ConcurrentHashMap());
    private Set<MappedByteBufferResources> mappedByteBufferResources = Collections.newSetFromMap(new ConcurrentHashMap());
    private Set<File> tempFiles = Collections.newSetFromMap(new ConcurrentHashMap());
    public static final String TEMP_FILENAME_LEAF_SEPARATOR = "---";
    private final AtomicBoolean closed = new AtomicBoolean(false);
    public InterruptionChecker interruptionChecker;

    public NestedJarHandler(ScanSpec scanSpec, InterruptionChecker interruptionChecker) {
        this.scanSpec = scanSpec;
        this.interruptionChecker = interruptionChecker;
    }

    public void addMappedByteBuffer(ByteBuffer byteBuffer) {
        this.mappedByteBuffers.add(new ReferenceEqualityKey<ByteBuffer>(byteBuffer));
    }

    public void unmapByteBuffer(ByteBuffer byteBuffer, LogNode log) {
        if (this.mappedByteBuffers.remove(new ReferenceEqualityKey<ByteBuffer>(byteBuffer))) {
            FileUtils.closeDirectByteBuffer(byteBuffer, log);
        }
    }

    private static String leafname(String path) {
        return path.substring(path.lastIndexOf(47) + 1);
    }

    private String sanitizeFilename(String filename) {
        return filename.replace('/', '_').replace('\\', '_').replace(':', '_').replace('?', '_').replace('&', '_').replace('=', '_').replace(' ', '_');
    }

    File makeTempFile(String filePathBase, boolean onlyUseLeafname) throws IOException {
        File tempFile = File.createTempFile("ClassGraph--", TEMP_FILENAME_LEAF_SEPARATOR + this.sanitizeFilename(onlyUseLeafname ? NestedJarHandler.leafname(filePathBase) : filePathBase));
        tempFile.deleteOnExit();
        this.tempFiles.add(tempFile);
        return tempFile;
    }

    void removeTempFile(File tempFile) throws IOException, SecurityException {
        if (this.tempFiles.contains(tempFile)) {
            try {
                Files.delete(tempFile.toPath());
            }
            finally {
                this.tempFiles.remove(tempFile);
            }
        } else {
            throw new IOException("Not a temp file: " + tempFile);
        }
    }

    private PhysicalZipFile downloadJarFromURL(String jarURL, LogNode log) throws IOException, InterruptedException {
        URL url = null;
        try {
            url = new URL(jarURL);
        }
        catch (MalformedURLException e1) {
            try {
                url = new URI(jarURL).toURL();
            }
            catch (URISyntaxException e2) {
                throw new IOException("Could not parse URL: " + jarURL);
            }
        }
        try {
            PhysicalZipFile physicalZipFile;
            block16: {
                InputStream inputStream = url.openStream();
                try {
                    PhysicalZipFile physicalZipFile2 = new PhysicalZipFile(inputStream, jarURL, this, log);
                    this.allocatedPhysicalZipFiles.add(physicalZipFile2);
                    physicalZipFile = physicalZipFile2;
                    if (inputStream == null) break block16;
                }
                catch (Throwable throwable) {
                    try {
                        if (inputStream != null) {
                            try {
                                inputStream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (MalformedURLException e) {
                        throw new IOException("Malformed URL: " + jarURL);
                    }
                }
                inputStream.close();
            }
            return physicalZipFile;
        }
        finally {
            if (log != null) {
                log.addElapsedTime();
                log.log("***** Note that it is time-consuming to scan jars at non-\"file:\" URLs, the URL must be opened (possibly after an http(s) fetch) for every scan, and the same URL must also be separately opened by the ClassLoader *****");
            }
        }
    }

    public void close(LogNode log) {
        if (!this.closed.getAndSet(true)) {
            Object logicalZipFile;
            if (this.inflaterRecycler != null) {
                this.inflaterRecycler.forceClose();
                this.inflaterRecycler = null;
            }
            if (this.moduleRefToModuleReaderProxyRecyclerMap != null) {
                try {
                    for (Recycler<ModuleReaderProxy, IOException> recycler : this.moduleRefToModuleReaderProxyRecyclerMap.values()) {
                        recycler.forceClose();
                    }
                }
                catch (InterruptedException e) {
                    this.interruptionChecker.interrupt();
                }
                this.moduleRefToModuleReaderProxyRecyclerMap.clear();
                this.moduleRefToModuleReaderProxyRecyclerMap = null;
            }
            if (this.zipFileSliceToLogicalZipFileMap != null) {
                this.zipFileSliceToLogicalZipFileMap.clear();
                this.zipFileSliceToLogicalZipFileMap = null;
            }
            if (this.nestedPathToLogicalZipFileAndPackageRootMap != null) {
                this.nestedPathToLogicalZipFileAndPackageRootMap.clear();
                this.nestedPathToLogicalZipFileAndPackageRootMap = null;
            }
            while ((logicalZipFile = this.allocatedLogicalZipFiles.poll()) != null) {
                ((LogicalZipFile)logicalZipFile).close();
            }
            if (this.canonicalFileToPhysicalZipFileMap != null) {
                while (!this.canonicalFileToPhysicalZipFileMap.isEmpty()) {
                    try {
                        for (Map.Entry entry : this.canonicalFileToPhysicalZipFileMap.entries()) {
                            PhysicalZipFile physicalZipFile = (PhysicalZipFile)entry.getValue();
                            physicalZipFile.close();
                            this.canonicalFileToPhysicalZipFileMap.remove((File)entry.getKey());
                        }
                    }
                    catch (InterruptedException e) {
                        this.interruptionChecker.interrupt();
                    }
                }
                this.canonicalFileToPhysicalZipFileMap = null;
            }
            if (this.allocatedPhysicalZipFiles != null) {
                Iterator<ReferenceEqualityKey<? extends ByteBuffer>> physicalZipFile;
                while ((physicalZipFile = this.allocatedPhysicalZipFiles.poll()) != null) {
                    ((PhysicalZipFile)((Object)physicalZipFile)).close();
                }
                this.allocatedPhysicalZipFiles.clear();
                this.allocatedPhysicalZipFiles = null;
            }
            if (this.fastZipEntryToZipFileSliceMap != null) {
                this.fastZipEntryToZipFileSliceMap.clear();
                this.fastZipEntryToZipFileSliceMap = null;
            }
            if (this.mappedByteBufferResources != null) {
                for (MappedByteBufferResources mappedByteBufferResources : this.mappedByteBufferResources) {
                    mappedByteBufferResources.close(log);
                }
                this.mappedByteBufferResources = null;
            }
            if (this.mappedByteBuffers != null) {
                while (!this.mappedByteBuffers.isEmpty()) {
                    for (ReferenceEqualityKey<? extends ByteBuffer> referenceEqualityKey : new ArrayList<ReferenceEqualityKey<? extends ByteBuffer>>(this.mappedByteBuffers)) {
                        this.unmapByteBuffer(referenceEqualityKey.get(), log);
                    }
                }
                this.mappedByteBuffers = null;
            }
            if (this.tempFiles != null) {
                LogNode rmLog;
                LogNode logNode = rmLog = this.tempFiles.isEmpty() || log == null ? null : log.log("Removing temporary files");
                while (!this.tempFiles.isEmpty()) {
                    for (File tempFile : new ArrayList<File>(this.tempFiles)) {
                        try {
                            this.removeTempFile(tempFile);
                        }
                        catch (IOException | SecurityException e) {
                            if (rmLog == null) continue;
                            rmLog.log("Removing temporary file failed: " + tempFile);
                        }
                    }
                }
                this.tempFiles = null;
            }
        }
    }
}

