/*
 * Decompiled with CFR 0.152.
 */
package nonapi.io.github.classgraph.utils;

import io.github.classgraph.ClassGraphException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.List;
import nonapi.io.github.classgraph.utils.FastPathResolver;
import nonapi.io.github.classgraph.utils.LogNode;
import nonapi.io.github.classgraph.utils.VersionFinder;

public final class FileUtils {
    private static Method cleanMethod;
    private static Method attachmentMethod;
    private static Object theUnsafe;
    public static final String CURR_DIR_PATH;
    public static final int MAX_BUFFER_SIZE = 0x7FFFFFF7;

    private FileUtils() {
    }

    public static String sanitizeEntryPath(String path, boolean removeInitialSlash) {
        int startIdx;
        if (path.isEmpty()) {
            return "";
        }
        boolean foundSegmentToSanitize = false;
        int pathLen = path.length();
        char[] pathChars = new char[pathLen];
        path.getChars(0, pathLen, pathChars, 0);
        int lastSepIdx = -1;
        char prevC = '\u0000';
        int ii = pathLen + 1;
        for (int i = 0; i < ii; ++i) {
            char c;
            char c2 = c = i == pathLen ? (char)'\u0000' : pathChars[i];
            if (c == '/' || c == '!' || c == '\u0000') {
                int segmentLength = i - (lastSepIdx + 1);
                if (segmentLength == 0 && prevC == c || segmentLength == 1 && pathChars[i - 1] == '.' || segmentLength == 2 && pathChars[i - 2] == '.' && pathChars[i - 1] == '.') {
                    foundSegmentToSanitize = true;
                }
                lastSepIdx = i;
            }
            prevC = c;
        }
        boolean pathHasInitialSlash = pathLen > 0 && pathChars[0] == '/';
        StringBuilder pathSanitized = new StringBuilder(pathLen + 16);
        if (foundSegmentToSanitize) {
            ArrayList allSectionSegments = new ArrayList();
            ArrayList<CharSequence> currSectionSegments = new ArrayList<CharSequence>();
            allSectionSegments.add(currSectionSegments);
            int lastSepIdx2 = -1;
            for (int i = 0; i < pathLen + 1; ++i) {
                char c;
                char c3 = c = i == pathLen ? (char)'\u0000' : pathChars[i];
                if (c != '/' && c != '!' && c != '\u0000') continue;
                int segmentStartIdx = lastSepIdx2 + 1;
                int segmentLen = i - segmentStartIdx;
                if (segmentLen != 0 && (segmentLen != 1 || pathChars[segmentStartIdx] != '.')) {
                    if (segmentLen == 2 && pathChars[segmentStartIdx] == '.' && pathChars[segmentStartIdx + 1] == '.') {
                        if (!currSectionSegments.isEmpty()) {
                            currSectionSegments.remove(currSectionSegments.size() - 1);
                        }
                    } else {
                        currSectionSegments.add(path.subSequence(segmentStartIdx, segmentStartIdx + segmentLen));
                    }
                }
                if (c == '!' && !currSectionSegments.isEmpty()) {
                    currSectionSegments = new ArrayList();
                    allSectionSegments.add(currSectionSegments);
                }
                lastSepIdx2 = i;
            }
            for (List list : allSectionSegments) {
                if (list.isEmpty()) continue;
                if (pathSanitized.length() > 0) {
                    pathSanitized.append('!');
                }
                for (CharSequence sectionSegment : list) {
                    pathSanitized.append('/');
                    pathSanitized.append(sectionSegment);
                }
            }
            if (pathSanitized.length() == 0 && pathHasInitialSlash) {
                pathSanitized.append('/');
            }
        } else {
            pathSanitized.append(path);
        }
        if (removeInitialSlash || !pathHasInitialSlash) {
            for (startIdx = 0; startIdx < pathSanitized.length() && pathSanitized.charAt(startIdx) == '/'; ++startIdx) {
            }
        }
        return pathSanitized.substring(startIdx);
    }

    public static boolean isClassfile(String path) {
        int len = path.length();
        return len > 6 && path.regionMatches(true, len - 6, ".class", 0, 6);
    }

    public static boolean canRead(File file) {
        try {
            return file.canRead();
        }
        catch (SecurityException e) {
            return false;
        }
    }

    public static boolean canReadAndIsFile(File file) {
        try {
            if (!file.canRead()) {
                return false;
            }
        }
        catch (SecurityException e) {
            return false;
        }
        return file.isFile();
    }

    public static void checkCanReadAndIsFile(File file) throws IOException {
        try {
            if (!file.canRead()) {
                throw new FileNotFoundException("File does not exist or cannot be read: " + file);
            }
        }
        catch (SecurityException e) {
            throw new FileNotFoundException("File " + file + " cannot be accessed: " + e);
        }
        if (!file.isFile()) {
            throw new IOException("Not a regular file: " + file);
        }
    }

    public static boolean canReadAndIsDir(File file) {
        try {
            if (!file.canRead()) {
                return false;
            }
        }
        catch (SecurityException e) {
            return false;
        }
        return file.isDirectory();
    }

    public static void checkCanReadAndIsDir(File file) throws IOException {
        try {
            if (!file.canRead()) {
                throw new FileNotFoundException("Directory does not exist or cannot be read: " + file);
            }
        }
        catch (SecurityException e) {
            throw new FileNotFoundException("File " + file + " cannot be accessed: " + e);
        }
        if (!file.isDirectory()) {
            throw new IOException("Not a directory: " + file);
        }
    }

    public static String getParentDirPath(String path, char separator) {
        int lastSlashIdx = path.lastIndexOf(separator);
        if (lastSlashIdx <= 0) {
            return "";
        }
        return path.substring(0, lastSlashIdx);
    }

    public static String getParentDirPath(String path) {
        return FileUtils.getParentDirPath(path, '/');
    }

    private static void lookupCleanMethodPrivileged() {
        if (VersionFinder.JAVA_MAJOR_VERSION < 9) {
            try {
                cleanMethod = Class.forName("sun.misc.Cleaner").getMethod("clean", new Class[0]);
                cleanMethod.setAccessible(true);
                attachmentMethod = Class.forName("sun.nio.ch.DirectBuffer").getMethod("attachment", new Class[0]);
                attachmentMethod.setAccessible(true);
            }
            catch (SecurityException e) {
                throw ClassGraphException.newClassGraphException("You need to grant classgraph RuntimePermission(\"accessClassInPackage.sun.misc\"), RuntimePermission(\"accessClassInPackage.sun.nio.ch\"), and ReflectPermission(\"suppressAccessChecks\")", e);
            }
            catch (LinkageError | ReflectiveOperationException e) {}
        } else {
            try {
                Class<?> unsafeClass;
                try {
                    unsafeClass = Class.forName("sun.misc.Unsafe");
                }
                catch (LinkageError | ReflectiveOperationException e) {
                    unsafeClass = Class.forName("jdk.internal.misc.Unsafe");
                }
                Field theUnsafeField = unsafeClass.getDeclaredField("theUnsafe");
                theUnsafeField.setAccessible(true);
                theUnsafe = theUnsafeField.get(null);
                cleanMethod = unsafeClass.getMethod("invokeCleaner", ByteBuffer.class);
                cleanMethod.setAccessible(true);
            }
            catch (SecurityException e) {
                throw ClassGraphException.newClassGraphException("You need to grant classgraph RuntimePermission(\"accessClassInPackage.sun.misc\"), RuntimePermission(\"accessClassInPackage.jdk.internal.misc\") and ReflectPermission(\"suppressAccessChecks\")", e);
            }
            catch (LinkageError | ReflectiveOperationException throwable) {
                // empty catch block
            }
        }
    }

    private static boolean closeDirectByteBufferPrivileged(ByteBuffer byteBuffer, LogNode log) {
        try {
            if (cleanMethod == null) {
                if (log != null) {
                    log.log("Could not unmap ByteBuffer, cleanMethod == null");
                }
                return false;
            }
            if (VersionFinder.JAVA_MAJOR_VERSION < 9) {
                if (attachmentMethod == null) {
                    if (log != null) {
                        log.log("Could not unmap ByteBuffer, attachmentMethod == null");
                    }
                    return false;
                }
                if (attachmentMethod.invoke((Object)byteBuffer, new Object[0]) != null) {
                    return false;
                }
                Method cleaner = byteBuffer.getClass().getMethod("cleaner", new Class[0]);
                if (cleaner == null) {
                    if (log != null) {
                        log.log("Could not unmap ByteBuffer, cleaner == null");
                    }
                    return false;
                }
                try {
                    cleaner.setAccessible(true);
                }
                catch (Exception e) {
                    if (log != null) {
                        log.log("Could not unmap ByteBuffer, cleaner.setAccessible(true) failed");
                    }
                    return false;
                }
                Object cleanerResult = cleaner.invoke((Object)byteBuffer, new Object[0]);
                if (cleanerResult == null) {
                    if (log != null) {
                        log.log("Could not unmap ByteBuffer, cleanerResult == null");
                    }
                    return false;
                }
                try {
                    cleanMethod.invoke(cleaner.invoke((Object)byteBuffer, new Object[0]), new Object[0]);
                    return true;
                }
                catch (Exception e) {
                    if (log != null) {
                        log.log("Could not unmap ByteBuffer, cleanMethod.invoke(cleanerResult) failed: " + e);
                    }
                    return false;
                }
            }
            if (theUnsafe == null) {
                if (log != null) {
                    log.log("Could not unmap ByteBuffer, theUnsafe == null");
                }
                return false;
            }
            try {
                cleanMethod.invoke(theUnsafe, byteBuffer);
                return true;
            }
            catch (IllegalArgumentException e) {
                return false;
            }
        }
        catch (ReflectiveOperationException | SecurityException e) {
            if (log != null) {
                log.log("Could not unmap ByteBuffer: " + e);
            }
            return false;
        }
    }

    public static boolean closeDirectByteBuffer(final ByteBuffer byteBuffer, final LogNode log) {
        if (byteBuffer != null && byteBuffer.isDirect()) {
            return AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

                @Override
                public Boolean run() {
                    return FileUtils.closeDirectByteBufferPrivileged(byteBuffer, log);
                }
            });
        }
        return false;
    }

    static {
        String currDirPathStr = "";
        try {
            Path currDirPath = Paths.get("", new String[0]).toAbsolutePath();
            currDirPathStr = currDirPath.toString();
            currDirPath = currDirPath.normalize();
            currDirPathStr = currDirPath.toString();
            currDirPath = currDirPath.toRealPath(LinkOption.NOFOLLOW_LINKS);
            currDirPathStr = currDirPath.toString();
            currDirPathStr = FastPathResolver.resolve(currDirPathStr);
        }
        catch (IOException e) {
            throw ClassGraphException.newClassGraphException("Could not resolve current directory: " + currDirPathStr, e);
        }
        CURR_DIR_PATH = currDirPathStr;
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                FileUtils.lookupCleanMethodPrivileged();
                return null;
            }
        });
    }
}

