/*
 * Decompiled with CFR 0.152.
 */
package org.ddr.image.tiff;

import com.drew.imaging.FileType;
import com.drew.metadata.Directory;
import com.drew.metadata.Metadata;
import com.drew.metadata.exif.ExifIFD0Directory;
import java.awt.Dimension;
import java.util.EnumSet;
import org.ddr.image.ImageType;
import org.ddr.image.MetadataReader;

public class TiffMetadataReader
implements MetadataReader {
    private static final EnumSet<FileType> TIFF_TYPES = EnumSet.of(FileType.Tiff, new FileType[]{FileType.Arw, FileType.Cr2, FileType.Nef, FileType.Orf, FileType.Rw2});

    @Override
    public boolean canRead(FileType type) {
        return TIFF_TYPES.contains(type);
    }

    @Override
    public ImageType getType(Metadata metadata) {
        return ImageType.TIFF;
    }

    @Override
    public Dimension getDimension(Metadata metadata) {
        for (Directory directory : metadata.getDirectories()) {
            if (!(directory instanceof ExifIFD0Directory)) continue;
            Integer width = directory.getInteger(256);
            Integer height = directory.getInteger(257);
            if (width == null || height == null) continue;
            return new Dimension(width, height);
        }
        return null;
    }
}

