/*
 * Decompiled with CFR 0.152.
 */
package org.ddr.image.webp;

import com.drew.imaging.FileType;
import com.drew.metadata.Directory;
import com.drew.metadata.Metadata;
import com.drew.metadata.webp.WebpDirectory;
import java.awt.Dimension;
import org.ddr.image.ImageType;
import org.ddr.image.MetadataReader;

public class WebpMetadataReader
implements MetadataReader {
    @Override
    public boolean canRead(FileType type) {
        return type == FileType.WebP;
    }

    @Override
    public ImageType getType(Metadata metadata) {
        for (Directory directory : metadata.getDirectories()) {
            Boolean hasAlpha;
            if (!(directory instanceof WebpDirectory) || !Boolean.TRUE.equals(hasAlpha = directory.getBooleanObject(3))) continue;
            return ImageType.PNG;
        }
        return ImageType.JPG;
    }

    @Override
    public Dimension getDimension(Metadata metadata) {
        for (Directory directory : metadata.getDirectories()) {
            if (!(directory instanceof WebpDirectory)) continue;
            Integer width = directory.getInteger(2);
            Integer height = directory.getInteger(1);
            if (width == null || height == null) continue;
            return new Dimension(width, height);
        }
        return null;
    }
}

