/*
 * Decompiled with CFR 0.152.
 */
package org.ddr.poi.math;

import com.deepoove.poi.policy.AbstractRenderPolicy;
import com.deepoove.poi.render.RenderContext;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.ddr.poi.math.MathMLUtils;
import org.ddr.poi.math.MathRenderConfig;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Element;

public class MathMLRenderPolicy
extends AbstractRenderPolicy<String> {
    private final MathRenderConfig config;
    private Element math;

    public MathMLRenderPolicy() {
        this(new MathRenderConfig());
    }

    public MathMLRenderPolicy(MathRenderConfig config) {
        this.config = config;
    }

    public MathRenderConfig getConfig() {
        return this.config;
    }

    protected boolean validate(String data) {
        if (StringUtils.isBlank((CharSequence)data)) {
            return false;
        }
        this.math = Jsoup.parseBodyFragment((String)data).selectFirst("math");
        return this.math != null;
    }

    public void doRender(RenderContext<String> context) throws Exception {
        if (!this.math.hasAttr("xmlns")) {
            this.math.attr("xmlns", "http://www.w3.org/1998/Math/MathML");
        }
        String mathml = this.math.outerHtml();
        MathMLUtils.renderTo((XWPFParagraph)context.getRun().getParent(), context.getRun().getCTR(), mathml, this.config);
    }

    protected void afterRender(RenderContext<String> context) {
        this.clearPlaceholder(context, false);
    }
}

