/*
 * Decompiled with CFR 0.152.
 */
package com.ruiyun.jvppeteer.core.browser;

import com.ruiyun.jvppeteer.core.browser.RevisionInfo;
import com.ruiyun.jvppeteer.options.FetcherOptions;
import com.ruiyun.jvppeteer.util.DownloadUtil;
import com.ruiyun.jvppeteer.util.FileUtil;
import com.ruiyun.jvppeteer.util.Helper;
import com.ruiyun.jvppeteer.util.StreamUtil;
import com.ruiyun.jvppeteer.util.StringUtil;
import com.ruiyun.jvppeteer.util.ValidateUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.math.BigDecimal;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.function.BiConsumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import net.lingala.zip4j.ZipFile;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BrowserFetcher {
    private static final Logger LOGGER = LoggerFactory.getLogger(BrowserFetcher.class);
    public static final Map<String, Map<String, String>> downloadURLs = new HashMap<String, Map<String, String>>(){
        private static final long serialVersionUID = -6918778699407093058L;
        {
            this.put("chrome", new HashMap<String, String>(){
                private static final long serialVersionUID = 3441562966233820720L;
                {
                    this.put("host", "https://npm.taobao.org/mirrors");
                    this.put("linux", "%s/chromium-browser-snapshots/Linux_x64/%s/%s.zip");
                    this.put("mac", "%s/chromium-browser-snapshots/Mac/%s/%s.zip");
                    this.put("win32", "%s/chromium-browser-snapshots/Win/%s/%s.zip");
                    this.put("win64", "%s/chromium-browser-snapshots/Win_x64/%s/%s.zip");
                }
            });
            this.put("firefox", new HashMap<String, String>(){
                private static final long serialVersionUID = 2053771138227029401L;
                {
                    this.put("host", "https://github.com/puppeteer/juggler/releases");
                    this.put("linux", "%s/download/%s/%s.zip");
                    this.put("mac", "%s/download/%s/%s.zip");
                    this.put("win32", "%s/download/%s/%s.zip");
                    this.put("win64", "%s/download/%s/%s.zip");
                }
            });
        }
    };
    private String platform;
    private String downloadHost;
    private String downloadsFolder;
    private String product;

    public BrowserFetcher() {
        this.product = "chrome";
        this.downloadsFolder = Helper.join(System.getProperty("user.dir"), ".local-browser");
        this.downloadHost = downloadURLs.get(this.product).get("host");
        if (this.platform == null) {
            if (Helper.isMac()) {
                this.platform = "mac";
            } else if (Helper.isLinux()) {
                this.platform = "linux";
            } else if (Helper.isWindows()) {
                this.platform = Helper.isWin64() ? "win64" : "win32";
            }
            ValidateUtil.notNull(this.platform, "Unsupported platform: " + Helper.paltform());
        }
        ValidateUtil.notNull(downloadURLs.get(this.product).get(this.platform), "Unsupported platform: " + this.platform);
    }

    public BrowserFetcher(String projectRoot, FetcherOptions options) {
        this.product = (StringUtil.isNotEmpty(options.getProduct()) ? options.getProduct() : "chrome").toLowerCase();
        ValidateUtil.assertArg("chrome".equals(this.product) || "firefox".equals(this.product), "Unkown product: " + options.getProduct());
        this.downloadsFolder = StringUtil.isNotEmpty(options.getPath()) ? options.getPath() : Helper.join(projectRoot, ".local-browser");
        this.downloadHost = StringUtil.isNotEmpty(options.getHost()) ? options.getHost() : downloadURLs.get(this.product).get("host");
        String string = this.platform = StringUtil.isNotEmpty(options.getPlatform()) ? options.getPlatform() : null;
        if (this.platform == null) {
            if (Helper.isMac()) {
                this.platform = "mac";
            } else if (Helper.isLinux()) {
                this.platform = "linux";
            } else if (Helper.isWindows()) {
                this.platform = Helper.isWin64() ? "win64" : "win32";
            }
            ValidateUtil.notNull(this.platform, "Unsupported platform: " + Helper.paltform());
        }
        ValidateUtil.notNull(downloadURLs.get(this.product).get(this.platform), "Unsupported platform: " + this.platform);
    }

    public static RevisionInfo downloadIfNotExist() throws InterruptedException, ExecutionException, IOException {
        return BrowserFetcher.downloadIfNotExist(null);
    }

    public static RevisionInfo downloadIfNotExist(String version) throws InterruptedException, ExecutionException, IOException {
        BrowserFetcher fetcher = new BrowserFetcher();
        String downLoadVersion = StringUtil.isEmpty(version) ? "722234" : version;
        RevisionInfo revisionInfo = fetcher.revisionInfo(downLoadVersion);
        if (!revisionInfo.getLocal()) {
            return fetcher.download(downLoadVersion);
        }
        return revisionInfo;
    }

    public boolean canDownload(String revision, Proxy proxy) throws IOException {
        String url = this.downloadURL(this.product, this.platform, this.downloadHost, revision);
        return this.httpRequest(proxy, url, "HEAD");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean httpRequest(Proxy proxy, String url, String method) throws IOException {
        HttpURLConnection conn = null;
        try {
            URL urlSend = new URL(url);
            conn = proxy != null ? (HttpURLConnection)urlSend.openConnection(proxy) : (HttpURLConnection)urlSend.openConnection();
            conn.setRequestMethod(method);
            conn.connect();
            if (conn.getResponseCode() >= 300 && conn.getResponseCode() <= 400 && StringUtil.isNotEmpty(conn.getHeaderField("Location"))) {
                this.httpRequest(proxy, conn.getHeaderField("Location"), method);
            } else if (conn.getResponseCode() == 200) {
                boolean bl = true;
                return bl;
            }
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RevisionInfo download(String revision, BiConsumer<Integer, Integer> progressCallback) throws IOException, InterruptedException, ExecutionException {
        String url = this.downloadURL(this.product, this.platform, this.downloadHost, revision);
        int lastIndexOf = url.lastIndexOf("/");
        String archivePath = Helper.join(this.downloadsFolder, url.substring(lastIndexOf));
        String folderPath = this.getFolderPath(revision);
        if (this.existsAsync(folderPath)) {
            return this.revisionInfo(revision);
        }
        if (!this.existsAsync(this.downloadsFolder)) {
            this.mkdirAsync(this.downloadsFolder);
        }
        try {
            if (progressCallback == null) {
                progressCallback = this.defaultDownloadCallback();
            }
            this.downloadFile(url, archivePath, progressCallback);
            this.install(archivePath, folderPath);
        }
        finally {
            this.unlinkAsync(archivePath);
        }
        RevisionInfo revisionInfo = this.revisionInfo(revision);
        if (revisionInfo != null) {
            try {
                File executableFile = new File(revisionInfo.getExecutablePath());
                executableFile.setExecutable(true, false);
            }
            catch (Exception e) {
                LOGGER.error("Set executablePath:{} file executation permission fail.", (Object)revisionInfo.getExecutablePath());
            }
        }
        return revisionInfo;
    }

    public RevisionInfo download(String revision) throws IOException, InterruptedException, ExecutionException {
        return this.download(revision, null);
    }

    private BiConsumer<Integer, Integer> defaultDownloadCallback() {
        return (integer1, integer2) -> {
            BigDecimal decimal1 = new BigDecimal((int)integer1);
            BigDecimal decimal2 = new BigDecimal((int)integer2);
            int percent = decimal1.divide(decimal2, 2, 4).multiply(new BigDecimal(100)).intValue();
            LOGGER.info("Download progress: total[{}M],downloaded[{}M],{}", new Object[]{decimal2, decimal1, percent + "%"});
        };
    }

    public RevisionInfo download(BiConsumer<Integer, Integer> progressCallback) throws IOException, InterruptedException, ExecutionException {
        return this.download(this.fetchRevision(), progressCallback);
    }

    public RevisionInfo download() throws IOException, InterruptedException, ExecutionException {
        return this.download(this.fetchRevision(), null);
    }

    private String fetchRevision() throws IOException {
        String downloadUrl = downloadURLs.get(this.product).get(this.platform);
        URL urlSend = new URL(String.format(downloadUrl.substring(0, downloadUrl.length() - 9), this.downloadHost));
        URLConnection conn = urlSend.openConnection();
        conn.setConnectTimeout(10000);
        conn.setReadTimeout(10000);
        String pageContent = StreamUtil.toString(conn.getInputStream());
        return this.parseRevision(pageContent);
    }

    private String parseRevision(String pageContent) {
        String result = null;
        Pattern pattern = Pattern.compile("<a href=\"/mirrors/chromium-browser-snapshots/(.*)?/\">");
        Matcher matcher = pattern.matcher(pageContent);
        while (matcher.find()) {
            result = matcher.group(1);
        }
        String[] split = ((String)Objects.requireNonNull(result)).split("/");
        if (split.length != 2) {
            throw new RuntimeException("cant't find latest revision from pageConten:" + pageContent);
        }
        result = split[1];
        return result;
    }

    public List<String> localRevisions() throws IOException {
        if (!this.existsAsync(this.downloadsFolder)) {
            return new ArrayList<String>();
        }
        Path path = Paths.get(this.downloadsFolder, new String[0]);
        Stream<Path> fileNames = this.readdirAsync(path);
        return fileNames.map(fileName -> this.parseFolderPath(this.product, (Path)fileName)).filter(entry -> entry != null && this.platform.equals(entry.getPlatform())).map(RevisionEntry::getRevision).collect(Collectors.toList());
    }

    public void remove(String revision) throws IOException {
        String folderPath = this.getFolderPath(revision);
        ValidateUtil.assertArg(this.existsAsync(folderPath), "Failed to remove: revision " + revision + " is not downloaded");
        Files.delete(Paths.get(folderPath, new String[0]));
    }

    private RevisionEntry parseFolderPath(String product, Path folderPath) {
        Path fileName = folderPath.getFileName();
        String[] split = fileName.toString().split("-");
        if (split.length != 2) {
            return null;
        }
        if (downloadURLs.get(product).get(split[0]) == null) {
            return null;
        }
        RevisionEntry entry = new RevisionEntry();
        entry.setPlatform(split[0]);
        entry.setProduct(product);
        entry.setRevision(split[1]);
        return entry;
    }

    private Stream<Path> readdirAsync(Path downloadsFolder) throws IOException {
        ValidateUtil.assertArg(Files.isDirectory(downloadsFolder, new LinkOption[0]), "downloadsFolder " + downloadsFolder.toString() + " is not Directory");
        return Files.list(downloadsFolder);
    }

    private void chmodAsync(String executablePath, String perms) throws IOException {
        Helper.chmod(executablePath, perms);
    }

    private void unlinkAsync(String archivePath) throws IOException {
        Files.deleteIfExists(Paths.get(archivePath, new String[0]));
    }

    private void install(String archivePath, String folderPath) throws IOException {
        LOGGER.info("Installing " + archivePath + " to " + folderPath);
        if (archivePath.endsWith(".zip")) {
            this.extractZip(archivePath, folderPath);
        } else if (archivePath.endsWith(".tar.bz2")) {
            this.extractTar(archivePath, folderPath);
        } else if (archivePath.endsWith(".dmg")) {
            this.mkdirAsync(folderPath);
            this.installDMG(archivePath, folderPath);
        } else {
            throw new IllegalArgumentException("Unsupported archive format: " + archivePath);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String mountAndCopy(String archivePath, String folderPath) throws IOException, InterruptedException {
        String line;
        String mountPath = null;
        BufferedReader reader = null;
        StringWriter stringWriter = null;
        try {
            ArrayList<String> arguments = new ArrayList<String>();
            arguments.add("/bin/sh");
            arguments.add("-c");
            arguments.add("hdiutil");
            arguments.add("attach");
            arguments.add("-nobrowse");
            arguments.add("-noautoopen");
            arguments.add(archivePath);
            ProcessBuilder processBuilder = new ProcessBuilder(new String[0]).command(arguments).redirectErrorStream(true);
            Process process = processBuilder.start();
            reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            Pattern pattern = Pattern.compile("/Volumes/(.*)", 8);
            stringWriter = new StringWriter();
            while ((line = reader.readLine()) != null) {
                stringWriter.write(line);
            }
            process.waitFor();
            process.destroyForcibly();
            Matcher matcher = pattern.matcher(stringWriter.toString());
            while (matcher.find()) {
                mountPath = matcher.group();
            }
        }
        catch (Throwable throwable) {
            StreamUtil.closeQuietly(reader);
            StreamUtil.closeQuietly(stringWriter);
            throw throwable;
        }
        StreamUtil.closeQuietly(reader);
        StreamUtil.closeQuietly(stringWriter);
        if (StringUtil.isEmpty(mountPath)) {
            throw new RuntimeException("Could not find volume path in [" + stringWriter.toString() + "]");
        }
        Optional<Path> optionl = this.readdirAsync(Paths.get(mountPath, new String[0])).filter(item -> item.toString().endsWith(".app")).findFirst();
        if (optionl.isPresent()) {
            try {
                Path path = optionl.get();
                String copyPath = path.toString();
                LOGGER.info("Copying " + copyPath + " to " + folderPath);
                ArrayList<String> arguments = new ArrayList<String>();
                arguments.add("/bin/sh");
                arguments.add("-c");
                arguments.add("cp");
                arguments.add("-R");
                arguments.add(copyPath);
                arguments.add(folderPath);
                ProcessBuilder processBuilder2 = new ProcessBuilder(new String[0]).command(arguments);
                Process process2 = processBuilder2.start();
                reader = new BufferedReader(new InputStreamReader(process2.getInputStream()));
                while ((line = reader.readLine()) != null) {
                    LOGGER.trace(line);
                }
                reader.close();
                reader = new BufferedReader(new InputStreamReader(process2.getErrorStream()));
                while ((line = reader.readLine()) != null) {
                    LOGGER.error(line);
                }
                process2.waitFor();
                process2.destroyForcibly();
            }
            finally {
                StreamUtil.closeQuietly(reader);
            }
        }
        return mountPath;
    }

    private void installDMG(String archivePath, String folderPath) throws IOException {
        ZipFile zipFile = new ZipFile(archivePath);
        zipFile.extractAll(folderPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unmount(String mountPath) throws IOException, InterruptedException {
        BufferedReader reader = null;
        if (StringUtil.isEmpty(mountPath)) {
            return;
        }
        ArrayList<String> arguments = new ArrayList<String>();
        arguments.add("/bin/sh");
        arguments.add("-c");
        arguments.add("hdiutil");
        arguments.add("detach");
        arguments.add(mountPath);
        arguments.add("-quiet");
        try {
            String line;
            ProcessBuilder processBuilder3 = new ProcessBuilder(new String[0]).command(arguments);
            Process process3 = processBuilder3.start();
            LOGGER.info("Unmounting " + mountPath);
            reader = new BufferedReader(new InputStreamReader(process3.getInputStream()));
            while ((line = reader.readLine()) != null) {
                LOGGER.trace(line);
            }
            reader.close();
            reader = new BufferedReader(new InputStreamReader(process3.getErrorStream()));
            while ((line = reader.readLine()) != null) {
                LOGGER.error(line);
            }
            process3.waitFor();
            process3.destroyForcibly();
        }
        catch (Throwable throwable) {
            StreamUtil.closeQuietly(reader);
            throw throwable;
        }
        StreamUtil.closeQuietly(reader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void extractTar(String archivePath, String folderPath) throws IOException {
        BufferedOutputStream wirter = null;
        BufferedInputStream reader = null;
        TarArchiveInputStream tarArchiveInputStream = null;
        try {
            ArchiveEntry nextEntry;
            tarArchiveInputStream = new TarArchiveInputStream((InputStream)new FileInputStream(archivePath));
            while ((nextEntry = tarArchiveInputStream.getNextEntry()) != null) {
                int perReadcount;
                String name = nextEntry.getName();
                Path path = Paths.get(folderPath, name);
                File file = path.toFile();
                if (nextEntry.isDirectory()) {
                    file.mkdirs();
                    continue;
                }
                reader = new BufferedInputStream((InputStream)tarArchiveInputStream);
                int bufferSize = 8192;
                FileUtil.createNewFile(file);
                byte[] buffer = new byte[bufferSize];
                wirter = new BufferedOutputStream(new FileOutputStream(file));
                while ((perReadcount = reader.read(buffer, 0, bufferSize)) != -1) {
                    wirter.write(buffer, 0, perReadcount);
                }
                wirter.flush();
            }
        }
        finally {
            StreamUtil.closeQuietly(wirter);
            StreamUtil.closeQuietly(reader);
            StreamUtil.closeQuietly((Closeable)tarArchiveInputStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void extractZip(String archivePath, String folderPath) throws IOException {
        BufferedOutputStream wirter = null;
        BufferedInputStream reader = null;
        java.util.zip.ZipFile zipFile = new java.util.zip.ZipFile(archivePath);
        Enumeration<? extends ZipEntry> entries = zipFile.entries();
        try {
            while (entries.hasMoreElements()) {
                ZipEntry zipEntry = entries.nextElement();
                String name = zipEntry.getName();
                Path path = Paths.get(folderPath, name);
                if (zipEntry.isDirectory()) {
                    path.toFile().mkdirs();
                    continue;
                }
                try {
                    int perReadcount;
                    reader = new BufferedInputStream(zipFile.getInputStream(zipEntry));
                    byte[] buffer = new byte[8192];
                    wirter = new BufferedOutputStream(new FileOutputStream(path.toString()));
                    while ((perReadcount = reader.read(buffer, 0, 8192)) != -1) {
                        wirter.write(buffer, 0, perReadcount);
                    }
                    wirter.flush();
                }
                catch (Throwable throwable) {
                    StreamUtil.closeQuietly(wirter);
                    StreamUtil.closeQuietly(reader);
                    throw throwable;
                    return;
                }
                StreamUtil.closeQuietly(wirter);
                StreamUtil.closeQuietly(reader);
            }
        }
        finally {
            StreamUtil.closeQuietly(wirter);
            StreamUtil.closeQuietly(reader);
            StreamUtil.closeQuietly(zipFile);
        }
    }

    private void downloadFile(String url, String archivePath, BiConsumer<Integer, Integer> progressCallback) throws IOException, ExecutionException, InterruptedException {
        LOGGER.info("Downloading binary from " + url);
        DownloadUtil.download(url, archivePath, progressCallback);
        LOGGER.info("Download successfully from " + url);
    }

    private void mkdirAsync(String folder) throws IOException {
        File file = new File(folder);
        if (!file.exists()) {
            Files.createDirectory(file.toPath(), new FileAttribute[0]);
        }
    }

    public String getFolderPath(String revision) {
        return Paths.get(this.downloadsFolder, this.platform + "-" + revision).toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public RevisionInfo revisionInfo(String revision) {
        String executablePath;
        String folderPath = this.getFolderPath(revision);
        if ("chrome".equals(this.product)) {
            if ("mac".equals(this.platform)) {
                executablePath = Helper.join(folderPath, this.archiveName(this.product, this.platform, revision), "Chromium.app", "Contents", "MacOS", "Chromium");
            } else if ("linux".equals(this.platform)) {
                executablePath = Helper.join(folderPath, this.archiveName(this.product, this.platform, revision), "chrome");
            } else {
                if (!"win32".equals(this.platform) && !"win64".equals(this.platform)) throw new IllegalArgumentException("Unsupported platform: " + this.platform);
                executablePath = Helper.join(folderPath, this.archiveName(this.product, this.platform, revision), "chrome.exe");
            }
        } else {
            if (!"firefox".equals(this.product)) throw new IllegalArgumentException("Unsupported product: " + this.product);
            if ("mac".equals(this.platform)) {
                executablePath = Helper.join(folderPath, "Firefox Nightly.app", "Contents", "MacOS", "firefox");
            } else if ("linux".equals(this.platform)) {
                executablePath = Helper.join(folderPath, "firefox", "firefox");
            } else {
                if (!"win32".equals(this.platform) && !"win64".equals(this.platform)) throw new IllegalArgumentException("Unsupported platform: " + this.platform);
                executablePath = Helper.join(folderPath, "firefox", "firefox.exe");
            }
        }
        String url = this.downloadURL(this.product, this.platform, this.downloadHost, revision);
        boolean local = this.existsAsync(folderPath);
        LOGGER.info("revision:{}\uff0cexecutablePath:{}\uff0cfolderPath:{}\uff0clocal:{}\uff0curl:{}\uff0cproduct:{}", new Object[]{revision, executablePath, folderPath, local, url, this.product});
        return new RevisionInfo(revision, executablePath, folderPath, local, url, this.product);
    }

    public boolean existsAsync(String filePath) {
        return Files.exists(Paths.get(filePath, new String[0]), new LinkOption[0]);
    }

    public String archiveName(String product, String platform, String revision) {
        if ("chrome".equals(product)) {
            if ("linux".equals(platform)) {
                return "chrome-linux";
            }
            if ("mac".equals(platform)) {
                return "chrome-mac";
            }
            if ("win32".equals(platform) || "win64".equals(platform)) {
                return Integer.parseInt(revision) > 591479 ? "chrome-win" : "chrome-win32";
            }
        } else if ("firefox".equals(product)) {
            if ("linux".equals(platform)) {
                return "firefox-linux";
            }
            if ("mac".equals(platform)) {
                return "firefox-mac";
            }
            if ("win32".equals(platform) || "win64".equals(platform)) {
                return "firefox-" + platform;
            }
        }
        return null;
    }

    public String downloadURL(String product, String platform, String host, String revision) {
        return String.format(downloadURLs.get(product).get(platform), host, revision, this.archiveName(product, platform, revision));
    }

    public String host() {
        return this.downloadHost;
    }

    public String platform() {
        return this.platform;
    }

    public String getDownloadsFolder() {
        return this.downloadsFolder;
    }

    public void setDownloadsFolder(String downloadsFolder) {
        this.downloadsFolder = downloadsFolder;
    }

    public String product() {
        return this.product;
    }

    public static class RevisionEntry {
        private String product;
        private String platform;
        private String revision;

        public String getProduct() {
            return this.product;
        }

        public void setProduct(String product) {
            this.product = product;
        }

        public String getPlatform() {
            return this.platform;
        }

        public void setPlatform(String platform) {
            if (StringUtil.isNotEmpty(platform)) {
                this.platform = platform;
                return;
            }
            if (platform == null) {
                if (Helper.isMac()) {
                    this.platform = "mac";
                } else if (Helper.isLinux()) {
                    this.platform = "linux";
                } else if (Helper.isWindows()) {
                    this.platform = Helper.isWin64() ? "win64" : "win32";
                }
                ValidateUtil.notNull(this.platform, "Unsupported platform: " + Helper.paltform());
            }
        }

        public String getRevision() {
            return this.revision;
        }

        public void setRevision(String revision) {
            this.revision = revision;
        }
    }
}

