/*
 * Decompiled with CFR 0.152.
 */
package com.ruiyun.jvppeteer.core.page;

import com.ruiyun.jvppeteer.protocol.log.DialogType;
import com.ruiyun.jvppeteer.transport.CDPSession;
import com.ruiyun.jvppeteer.util.Helper;
import com.ruiyun.jvppeteer.util.StringUtil;
import com.ruiyun.jvppeteer.util.ValidateUtil;
import java.util.HashMap;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Dialog {
    private static final Logger log = LoggerFactory.getLogger(Dialog.class);
    private CDPSession client;
    private String type;
    private String message;
    private String defaultValue = "";
    private boolean handled;

    public Dialog() {
    }

    public Dialog(CDPSession client, DialogType type, String message, String defaultValue) {
        this.client = client;
        this.type = type.getType();
        this.message = message;
        this.handled = false;
        if (StringUtil.isNotEmpty(defaultValue)) {
            this.defaultValue = defaultValue;
        }
    }

    public String type() {
        return this.type;
    }

    public String message() {
        return this.message;
    }

    public String defaultValue() {
        return this.defaultValue;
    }

    public Future<Boolean> accept(String promptText) {
        return Helper.commonExecutor().submit(() -> {
            try {
                ValidateUtil.assertArg(!this.handled, "Cannot accept dialog which is already handled!");
                this.handled = true;
                HashMap<String, Object> params = new HashMap<String, Object>();
                params.put("accept", true);
                params.put("promptText", promptText);
                this.client.send("Page.handleJavaScriptDialog", params, true);
            }
            catch (Exception e) {
                log.error("Dialog accept error ", (Throwable)e);
                return false;
            }
            return true;
        });
    }

    public Future<Boolean> dismiss() {
        return Helper.commonExecutor().submit(() -> {
            try {
                ValidateUtil.assertArg(!this.handled, "Cannot dismiss dialog which is already handled!");
                this.handled = true;
                HashMap<String, Object> params = new HashMap<String, Object>();
                params.put("accept", false);
                this.client.send("Page.handleJavaScriptDialog", params, true);
            }
            catch (Exception e) {
                log.error("Dialog dismiss error ", (Throwable)e);
                return false;
            }
            return true;
        });
    }

    public String toString() {
        return "Dialog{type='" + this.type + '\'' + ", message='" + this.message + '\'' + ", defaultValue='" + this.defaultValue + '\'' + ", handled=" + this.handled + '}';
    }
}

