/*
 * Decompiled with CFR 0.152.
 */
package com.ruiyun.jvppeteer.transport;

import com.fasterxml.jackson.databind.JsonNode;
import com.ruiyun.jvppeteer.events.EventEmitter;
import com.ruiyun.jvppeteer.events.Events;
import com.ruiyun.jvppeteer.exception.ProtocolException;
import com.ruiyun.jvppeteer.exception.TimeoutException;
import com.ruiyun.jvppeteer.transport.Connection;
import com.ruiyun.jvppeteer.transport.SendMsg;
import com.ruiyun.jvppeteer.util.Helper;
import com.ruiyun.jvppeteer.util.StringUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CDPSession
extends EventEmitter {
    private static final Logger LOGGER = LoggerFactory.getLogger(CDPSession.class);
    private final Map<Long, SendMsg> callbacks = new ConcurrentHashMap<Long, SendMsg>();
    private final String targetType;
    private final String sessionId;
    private Connection connection;

    public CDPSession(Connection connection, String targetType, String sessionId) {
        this.targetType = targetType;
        this.sessionId = sessionId;
        this.connection = connection;
    }

    public void onClosed() {
        for (SendMsg callback : this.callbacks.values()) {
            callback.setErrorText("Protocol error " + callback.getMethod() + " Target closed.");
            if (callback.getCountDownLatch() == null) continue;
            callback.getCountDownLatch().countDown();
        }
        this.connection = null;
        this.callbacks.clear();
        this.emit(Events.CDPSESSION_DISCONNECTED.getName(), null);
    }

    public JsonNode send(String method, Map<String, Object> params, boolean isBlock, CountDownLatch outLatch, int timeout) {
        if (this.connection == null) {
            throw new ProtocolException("Protocol error (" + method + "): Session closed. Most likely the" + this.targetType + "has been closed.");
        }
        SendMsg message = new SendMsg();
        message.setMethod(method);
        message.setParams(params);
        message.setSessionId(this.sessionId);
        try {
            if (isBlock) {
                if (outLatch != null) {
                    message.setCountDownLatch(outLatch);
                } else {
                    CountDownLatch latch = new CountDownLatch(1);
                    message.setCountDownLatch(latch);
                }
                long id = this.connection.rawSend(message, true, this.callbacks);
                boolean hasResult = message.waitForResult(timeout > 0 ? (long)timeout : 30000L, TimeUnit.MILLISECONDS);
                if (!hasResult) {
                    throw new TimeoutException("Wait " + method + " for " + (timeout > 0 ? timeout : 30000) + " MILLISECONDS with no response");
                }
                if (StringUtil.isNotEmpty(message.getErrorText())) {
                    throw new ProtocolException(message.getErrorText());
                }
                return this.callbacks.remove(id).getResult();
            }
            if (outLatch != null) {
                message.setNeedRemove(true);
                message.setCountDownLatch(outLatch);
                this.connection.rawSend(message, true, this.callbacks);
            } else {
                this.connection.rawSend(message, false, this.callbacks);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return null;
    }

    public JsonNode send(String method, Map<String, Object> params, boolean isBlock) {
        if (this.connection == null) {
            throw new ProtocolException("Protocol error (" + method + "): Session closed. Most likely the" + this.targetType + "has been closed.");
        }
        SendMsg message = new SendMsg();
        message.setMethod(method);
        message.setParams(params);
        message.setSessionId(this.sessionId);
        try {
            if (isBlock) {
                CountDownLatch latch = new CountDownLatch(1);
                message.setCountDownLatch(latch);
                long id = this.connection.rawSend(message, true, this.callbacks);
                message.waitForResult(0L, TimeUnit.MILLISECONDS);
                if (StringUtil.isNotEmpty(message.getErrorText())) {
                    throw new ProtocolException(message.getErrorText());
                }
                return this.callbacks.remove(id).getResult();
            }
            this.connection.rawSend(message, false, this.callbacks);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        return null;
    }

    public void detach() {
        if (this.connection == null) {
            throw new RuntimeException("Session already detached. Most likely the" + this.targetType + "has been closed.");
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("sessionId", this.sessionId);
        this.connection.send("Target.detachFromTarget", params, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void onMessage(JsonNode node) {
        JsonNode id = node.get("id");
        if (id != null) {
            Long idLong = id.asLong();
            SendMsg callback = this.callbacks.get(idLong);
            if (callback == null) return;
            try {
                JsonNode errNode = node.get("error");
                if (errNode != null) {
                    if (callback.getCountDownLatch() == null) return;
                    callback.setErrorText(Helper.createProtocolError(node));
                    return;
                }
                JsonNode result = node.get("result");
                callback.setResult(result);
                return;
            }
            finally {
                if (callback.getNeedRemove()) {
                    this.callbacks.remove(idLong);
                }
                if (callback.getCountDownLatch() != null) {
                    callback.getCountDownLatch().countDown();
                    callback.setCountDownLatch(null);
                }
            }
        } else {
            JsonNode paramsNode = node.get("params");
            JsonNode method = node.get("method");
            if (method == null) return;
            this.emit(method.asText(), paramsNode);
        }
    }

    public Connection getConnection() {
        return this.connection;
    }

    public String getSessionId() {
        return this.sessionId;
    }
}

