/*
 * Decompiled with CFR 0.152.
 */
package io.github.flyhero.easylog.aop;

import io.github.flyhero.easylog.annotation.EasyLog;
import io.github.flyhero.easylog.configuration.EasyLogProperties;
import io.github.flyhero.easylog.function.EasyLogParser;
import io.github.flyhero.easylog.model.EasyLogInfo;
import io.github.flyhero.easylog.model.EasyLogOps;
import io.github.flyhero.easylog.model.MethodExecuteResult;
import io.github.flyhero.easylog.service.ILogRecordService;
import io.github.flyhero.easylog.service.IOperatorService;
import io.github.flyhero.easylog.util.JsonUtils;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Objects;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.support.AopUtils;
import org.springframework.stereotype.Component;
import org.springframework.util.ObjectUtils;

@Aspect
@Component
public class EasyLogAspect {
    private static final Logger log = LoggerFactory.getLogger(EasyLogAspect.class);
    private ILogRecordService logRecordService;
    private IOperatorService operatorService;
    private EasyLogParser easyLogParser;
    private EasyLogProperties easyLogProperties;

    @Pointcut(value="@annotation(io.github.flyhero.easylog.annotation.EasyLog)")
    public void pointCut() {
    }

    @Around(value="pointCut() && @annotation(easyLog)")
    public Object around(ProceedingJoinPoint joinPoint, EasyLog easyLog) throws Throwable {
        MethodSignature methodSignature = (MethodSignature)joinPoint.getSignature();
        Method method = methodSignature.getMethod();
        Object[] args = joinPoint.getArgs();
        Object target = joinPoint.getTarget();
        Class targetClass = AopUtils.getTargetClass((Object)target);
        EasyLogOps easyLogOps = this.parseLogAnnotation(easyLog);
        Map<String, String> map = this.easyLogParser.processBeforeExec(easyLogOps, method, args, targetClass);
        Object result = null;
        MethodExecuteResult executeResult = new MethodExecuteResult(true);
        try {
            result = joinPoint.proceed();
            executeResult.calcExecuteTime();
        }
        catch (Throwable e) {
            executeResult.exception(e);
        }
        if (!executeResult.isSuccess() && ObjectUtils.isEmpty((Object)easyLogOps.getFail())) {
            log.warn("[{}] \u65b9\u6cd5\u6267\u884c\u5931\u8d25\uff0cEasyLog \u5931\u8d25\u6a21\u677f\u6ca1\u6709\u914d\u7f6e", (Object)method.getName());
        } else {
            Map<String, String> templateMap = this.easyLogParser.process(easyLogOps, map, method, args, targetClass, executeResult.getErrMsg(), result);
            this.sendLog(easyLogOps, result, executeResult, templateMap);
        }
        if (!executeResult.isSuccess()) {
            throw executeResult.getThrowable();
        }
        return result;
    }

    private void sendLog(EasyLogOps easyLogOps, Object result, MethodExecuteResult executeResult, Map<String, String> templateMap) {
        EasyLogInfo easyLogInfo = this.createEasyLogInfo(templateMap, easyLogOps);
        if (Objects.nonNull(easyLogInfo)) {
            easyLogInfo.setPlatform(this.easyLogProperties.getPlatform());
            easyLogInfo.setContent(executeResult.isSuccess() ? templateMap.get(easyLogOps.getSuccess()) : templateMap.get(easyLogOps.getFail()));
            easyLogInfo.setSuccess(executeResult.isSuccess());
            easyLogInfo.setResult(JsonUtils.toJSONString(result));
            easyLogInfo.setErrorMsg(executeResult.getErrMsg());
            easyLogInfo.setExecuteTime(executeResult.getExecuteTime());
            easyLogInfo.setOperateTime(executeResult.getOperateTime());
            this.logRecordService.record(easyLogInfo);
        }
    }

    private EasyLogInfo createEasyLogInfo(Map<String, String> templateMap, EasyLogOps easyLogOps) {
        if ("false".equalsIgnoreCase(templateMap.get(easyLogOps.getCondition()))) {
            return null;
        }
        EasyLogInfo easyLogInfo = new EasyLogInfo();
        String tenant = templateMap.get(easyLogOps.getTenant());
        if (ObjectUtils.isEmpty((Object)tenant)) {
            tenant = this.operatorService.getTenant();
        }
        easyLogInfo.setTenant(tenant);
        String operator = templateMap.get(easyLogOps.getOperator());
        if (ObjectUtils.isEmpty((Object)operator)) {
            operator = this.operatorService.getOperator();
        }
        easyLogInfo.setModule(easyLogOps.getModule());
        easyLogInfo.setType(easyLogOps.getType());
        easyLogInfo.setOperator(operator);
        easyLogInfo.setBizNo(templateMap.get(easyLogOps.getBizNo()));
        easyLogInfo.setDetails(templateMap.get(easyLogOps.getDetails()));
        return easyLogInfo;
    }

    private EasyLogOps parseLogAnnotation(EasyLog easyLog) {
        EasyLogOps easyLogOps = new EasyLogOps();
        easyLogOps.setSuccess(easyLog.success());
        easyLogOps.setFail(easyLog.fail());
        easyLogOps.setModule(easyLog.module());
        easyLogOps.setType(easyLog.type());
        easyLogOps.setOperator(easyLog.operator());
        easyLogOps.setBizNo(easyLog.bizNo());
        easyLogOps.setTenant(easyLog.tenant());
        easyLogOps.setDetails(easyLog.detail());
        easyLogOps.setCondition(easyLog.condition());
        return easyLogOps;
    }

    public EasyLogAspect(ILogRecordService logRecordService, IOperatorService operatorService, EasyLogParser easyLogParser, EasyLogProperties easyLogProperties) {
        this.logRecordService = logRecordService;
        this.operatorService = operatorService;
        this.easyLogParser = easyLogParser;
        this.easyLogProperties = easyLogProperties;
    }
}

