/*
 * Decompiled with CFR 0.152.
 */
package io.github.flyhero.easylog.configuration;

import io.github.flyhero.easylog.configuration.EasyLogProperties;
import io.github.flyhero.easylog.function.CustomFunctionFactory;
import io.github.flyhero.easylog.function.EasyLogParser;
import io.github.flyhero.easylog.function.ICustomFunction;
import io.github.flyhero.easylog.function.IFunctionService;
import io.github.flyhero.easylog.function.impl.DefaultCustomFunction;
import io.github.flyhero.easylog.function.impl.DefaultFunctionServiceImpl;
import io.github.flyhero.easylog.service.ILogRecordService;
import io.github.flyhero.easylog.service.IOperatorService;
import io.github.flyhero.easylog.service.impl.DefaultLogRecordServiceImpl;
import io.github.flyhero.easylog.service.impl.DefaultOperatorServiceImpl;
import io.github.flyhero.easylog.util.EasyLogVersion;
import java.util.List;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Role;

@Configuration
@ComponentScan(value={"io.github.flyhero.easylog"})
@ConditionalOnProperty(prefix="easylog", name={"enable"}, havingValue="true", matchIfMissing=true)
@EnableConfigurationProperties(value={EasyLogProperties.class})
public class EasyLogAutoConfiguration {
    @Autowired
    private EasyLogProperties easyLogProperties;

    @PostConstruct
    public void printBanner() {
        if (!this.easyLogProperties.isBanner()) {
            return;
        }
        System.out.println("                        _             \n                       | |            \n  ___  __ _ ___ _   _  | | ___   __ _ \n / _ \\/ _` / __| | | | | |/ _ \\ / _` |\n|  __/ (_| \\__ \\ |_| | | | (_) | (_| |\n \\___|\\__,_|___/\\__, | |_|\\___/ \\__, |\n                 __/ |           __/ |\n                |___/           |___/ \n");
        System.out.println("  <<easy-log>>            " + EasyLogVersion.getVersion() + " ");
    }

    @Bean
    @ConditionalOnMissingBean(value={ICustomFunction.class})
    @Role(value=0)
    public ICustomFunction customFunction() {
        return new DefaultCustomFunction();
    }

    @Bean
    public CustomFunctionFactory CustomFunctionRegistrar(@Autowired List<ICustomFunction> iCustomFunctionList) {
        return new CustomFunctionFactory(iCustomFunctionList);
    }

    @Bean
    public IFunctionService customFunctionService(CustomFunctionFactory customFunctionFactory) {
        return new DefaultFunctionServiceImpl(customFunctionFactory);
    }

    @Bean
    public EasyLogParser easyLogParser() {
        return new EasyLogParser();
    }

    @Bean
    @ConditionalOnMissingBean(value={IOperatorService.class})
    @Role(value=0)
    public IOperatorService operatorGetService() {
        return new DefaultOperatorServiceImpl();
    }

    @Bean
    @ConditionalOnMissingBean(value={ILogRecordService.class})
    @Role(value=0)
    public ILogRecordService recordService() {
        return new DefaultLogRecordServiceImpl();
    }
}

