/*
 * Decompiled with CFR 0.152.
 */
package io.github.flyhero.easylog.function;

import io.github.flyhero.easylog.context.ApplicationContextHolder;
import io.github.flyhero.easylog.function.ICustomFunction;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.util.CollectionUtils;

public class CustomFunctionFactory {
    private static final Map<String, ICustomFunction> customFunctionMap = new HashMap<String, ICustomFunction>();

    public CustomFunctionFactory(List<ICustomFunction> customFunctions) {
        for (ICustomFunction customFunction : customFunctions) {
            customFunctionMap.put(customFunction.functionName(), customFunction);
        }
    }

    private void register() {
        Map beansOfType = ApplicationContextHolder.getInstance().getBeansOfType(ICustomFunction.class);
        if (CollectionUtils.isEmpty((Map)beansOfType)) {
            return;
        }
        beansOfType.values().forEach(iCustomFunction -> customFunctionMap.put(iCustomFunction.functionName(), (ICustomFunction)iCustomFunction));
    }

    public ICustomFunction getFunction(String functionName) {
        return customFunctionMap.get(functionName);
    }
}

