/*
 * Decompiled with CFR 0.152.
 */
package io.github.flyhero.easylog.function;

import com.google.common.collect.Lists;
import io.github.flyhero.easylog.context.EasyLogCachedExpressionEvaluator;
import io.github.flyhero.easylog.exception.EasyLogException;
import io.github.flyhero.easylog.function.IFunctionService;
import io.github.flyhero.easylog.model.EasyLogOps;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.expression.AnnotatedElementKey;
import org.springframework.expression.EvaluationContext;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

public class EasyLogParser
implements BeanFactoryAware {
    private BeanFactory beanFactory;
    private static final Pattern PATTERN = Pattern.compile("\\{\\s*(\\w*)\\s*\\{(.*?)}}");
    @Autowired
    private IFunctionService customFunctionService;
    private final EasyLogCachedExpressionEvaluator cachedExpressionEvaluator = new EasyLogCachedExpressionEvaluator();

    public Map<String, String> process(EasyLogOps easyLogOps, Map<String, String> funcValBeforeExecMap, Method method, Object[] args, Class<?> targetClass, String errMsg, Object result) {
        HashMap<String, String> map = new HashMap<String, String>();
        List<String> expressTemplate = this.getExpressTemplate(easyLogOps);
        AnnotatedElementKey elementKey = new AnnotatedElementKey((AnnotatedElement)method, targetClass);
        EvaluationContext evaluationContext = this.cachedExpressionEvaluator.createEvaluationContext(method, args, this.beanFactory, errMsg, result);
        for (String template : expressTemplate) {
            if (template.contains("{")) {
                Matcher matcher = PATTERN.matcher(template);
                StringBuffer parsedStr = new StringBuffer();
                while (matcher.find()) {
                    Object value = this.cachedExpressionEvaluator.parseExpression(matcher.group(2), elementKey, evaluationContext);
                    String funcName = matcher.group(1);
                    String param = value == null ? "" : value.toString();
                    String functionVal = ObjectUtils.isEmpty((Object)funcName) ? param : this.getFunctionVal(funcValBeforeExecMap, funcName, param);
                    matcher.appendReplacement(parsedStr, functionVal);
                }
                matcher.appendTail(parsedStr);
                map.put(template, parsedStr.toString());
                continue;
            }
            Object value = null;
            try {
                value = this.cachedExpressionEvaluator.parseExpression(template, elementKey, evaluationContext);
            }
            catch (Exception e) {
                throw new EasyLogException(method.getDeclaringClass().getName() + "." + method.getName() + "\u4e0b EasyLog \u89e3\u6790\u5931\u8d25: [" + template + "], \u8bf7\u68c0\u67e5\u662f\u5426\u7b26\u5408SpEl\u8868\u8fbe\u5f0f\u89c4\u8303\uff01");
            }
            map.put(template, value == null ? "" : value.toString());
        }
        return map;
    }

    public Map<String, String> processBeforeExec(EasyLogOps easyLogOps, Method method, Object[] args, Class<?> targetClass) {
        HashMap<String, String> map = new HashMap<String, String>();
        AnnotatedElementKey elementKey = new AnnotatedElementKey((AnnotatedElement)method, targetClass);
        EvaluationContext evaluationContext = this.cachedExpressionEvaluator.createEvaluationContext(method, args, this.beanFactory, null, null);
        List<String> templates = this.getExpressTemplate(easyLogOps);
        for (String template : templates) {
            if (!template.contains("{")) continue;
            Matcher matcher = PATTERN.matcher(template);
            while (matcher.find()) {
                String funcName;
                String param = matcher.group(2);
                if (param.contains("#_errMsg") || param.contains("#_result") || !this.customFunctionService.executeBefore(funcName = matcher.group(1))) continue;
                Object value = this.cachedExpressionEvaluator.parseExpression(param, elementKey, evaluationContext);
                String apply = this.customFunctionService.apply(funcName, value == null ? null : value.toString());
                map.put(this.getFunctionMapKey(funcName, param), apply);
            }
        }
        return map;
    }

    private String getFunctionMapKey(String funcName, String param) {
        return funcName + param;
    }

    public String getFunctionVal(Map<String, String> funcValBeforeExecutionMap, String funcName, String param) {
        String val = null;
        if (!CollectionUtils.isEmpty(funcValBeforeExecutionMap)) {
            val = funcValBeforeExecutionMap.get(this.getFunctionMapKey(funcName, param));
        }
        if (ObjectUtils.isEmpty(val)) {
            val = this.customFunctionService.apply(funcName, param);
        }
        return val;
    }

    private List<String> getExpressTemplate(EasyLogOps easyLogOps) {
        ArrayList list = Lists.newArrayList((Object[])new String[]{easyLogOps.getBizNo(), easyLogOps.getDetails(), easyLogOps.getOperator(), easyLogOps.getTenant(), easyLogOps.getSuccess(), easyLogOps.getFail(), easyLogOps.getCondition()});
        return list.stream().filter(s -> !ObjectUtils.isEmpty((Object)s)).collect(Collectors.toList());
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }
}

