/*
 * Decompiled with CFR 0.152.
 */
package io.github.flyhero.easylog.model;

public class MethodExecuteResult {
    private boolean success;
    private Throwable throwable;
    private String errMsg;
    private Long operateTime;
    private Long executeTime;

    public MethodExecuteResult(boolean success) {
        this.success = success;
        this.operateTime = System.currentTimeMillis();
    }

    public MethodExecuteResult(boolean success, Throwable throwable, String errMsg) {
        this.success = success;
        this.throwable = throwable;
        this.errMsg = errMsg;
    }

    public void calcExecuteTime() {
        this.executeTime = System.currentTimeMillis() - this.operateTime;
    }

    public void exception(Throwable throwable) {
        this.success = false;
        this.executeTime = System.currentTimeMillis() - this.operateTime;
        this.throwable = throwable;
        this.errMsg = throwable.getMessage();
    }

    public boolean isSuccess() {
        return this.success;
    }

    public Throwable getThrowable() {
        return this.throwable;
    }

    public String getErrMsg() {
        return this.errMsg;
    }

    public Long getOperateTime() {
        return this.operateTime;
    }

    public Long getExecuteTime() {
        return this.executeTime;
    }

    public void setSuccess(boolean success) {
        this.success = success;
    }

    public void setThrowable(Throwable throwable) {
        this.throwable = throwable;
    }

    public void setErrMsg(String errMsg) {
        this.errMsg = errMsg;
    }

    public void setOperateTime(Long operateTime) {
        this.operateTime = operateTime;
    }

    public void setExecuteTime(Long executeTime) {
        this.executeTime = executeTime;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MethodExecuteResult)) {
            return false;
        }
        MethodExecuteResult other = (MethodExecuteResult)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isSuccess() != other.isSuccess()) {
            return false;
        }
        Long this$operateTime = this.getOperateTime();
        Long other$operateTime = other.getOperateTime();
        if (this$operateTime == null ? other$operateTime != null : !((Object)this$operateTime).equals(other$operateTime)) {
            return false;
        }
        Long this$executeTime = this.getExecuteTime();
        Long other$executeTime = other.getExecuteTime();
        if (this$executeTime == null ? other$executeTime != null : !((Object)this$executeTime).equals(other$executeTime)) {
            return false;
        }
        Throwable this$throwable = this.getThrowable();
        Throwable other$throwable = other.getThrowable();
        if (this$throwable == null ? other$throwable != null : !this$throwable.equals(other$throwable)) {
            return false;
        }
        String this$errMsg = this.getErrMsg();
        String other$errMsg = other.getErrMsg();
        return !(this$errMsg == null ? other$errMsg != null : !this$errMsg.equals(other$errMsg));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MethodExecuteResult;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isSuccess() ? 79 : 97);
        Long $operateTime = this.getOperateTime();
        result = result * 59 + ($operateTime == null ? 43 : ((Object)$operateTime).hashCode());
        Long $executeTime = this.getExecuteTime();
        result = result * 59 + ($executeTime == null ? 43 : ((Object)$executeTime).hashCode());
        Throwable $throwable = this.getThrowable();
        result = result * 59 + ($throwable == null ? 43 : $throwable.hashCode());
        String $errMsg = this.getErrMsg();
        result = result * 59 + ($errMsg == null ? 43 : $errMsg.hashCode());
        return result;
    }

    public String toString() {
        return "MethodExecuteResult(success=" + this.isSuccess() + ", throwable=" + this.getThrowable() + ", errMsg=" + this.getErrMsg() + ", operateTime=" + this.getOperateTime() + ", executeTime=" + this.getExecuteTime() + ")";
    }
}

