/*
 * Decompiled with CFR 0.152.
 */
package io.github.flyhero.easylog.util;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class JsonUtils {
    private static final Logger log = LoggerFactory.getLogger(JsonUtils.class);
    private static final ObjectMapper objectMapper = new ObjectMapper();
    private static final String STANDARD_FORMAT = "yyyy-MM-dd HH:mm:ss";

    public static <T> String toJSONString(T obj) {
        if (obj == null) {
            return null;
        }
        try {
            return obj instanceof String ? (String)obj : objectMapper.writeValueAsString(obj);
        }
        catch (JsonProcessingException e) {
            log.warn("Parse Object to String error : {}", (Object)e.getMessage());
            return null;
        }
    }

    public static <T> String toJSONStringAndFormat(T obj) {
        if (obj == null) {
            return null;
        }
        try {
            return obj instanceof String ? (String)obj : objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString(obj);
        }
        catch (JsonProcessingException e) {
            log.warn("Parse Object to String error : {}", (Object)e.getMessage());
            return null;
        }
    }

    public static <T> T toObject(String jsonStr, Class<T> clazz) {
        if (StringUtils.isEmpty((Object)jsonStr) || clazz == null) {
            return null;
        }
        try {
            return (T)(clazz.equals(String.class) ? jsonStr : objectMapper.readValue(jsonStr, clazz));
        }
        catch (Exception e) {
            log.warn("Parse String to Object error : {}", (Object)e.getMessage());
            return null;
        }
    }

    public static <T> T toObject(String jsonStr, TypeReference<T> typeReference) {
        if (StringUtils.isEmpty((Object)jsonStr) || typeReference == null) {
            return null;
        }
        try {
            return (T)(typeReference.getType().equals(String.class) ? jsonStr : objectMapper.readValue(jsonStr, typeReference));
        }
        catch (IOException e) {
            log.warn("Parse String to Object error", (Throwable)e);
            return null;
        }
    }

    public static <T> T toObject(String jsonStr, Class<?> collectionClazz, Class<?> ... elementClazzes) {
        JavaType javaType = objectMapper.getTypeFactory().constructParametricType(collectionClazz, (Class[])elementClazzes);
        try {
            return (T)objectMapper.readValue(jsonStr, javaType);
        }
        catch (IOException e) {
            log.warn("Parse String to Object error : {}" + e.getMessage());
            return null;
        }
    }

    static {
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
        objectMapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        objectMapper.setDateFormat((DateFormat)new SimpleDateFormat(STANDARD_FORMAT));
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }
}

