/*
 * Decompiled with CFR 0.152.
 */
package io.github.javpower.vectorexcore;

import io.github.javpower.vectorex.keynote.VectorDB;
import io.github.javpower.vectorex.keynote.storage.MapDBStorage;
import io.github.javpower.vectorexcore.entity.KeyValue;
import io.github.javpower.vectorexcore.entity.VectoRexEntity;
import java.util.List;
import java.util.stream.Collectors;
import org.mapdb.DB;
import org.mapdb.HTreeMap;

public class VectoRexClient {
    private static final Integer maxDataCount = 1000000;
    private HTreeMap<String, VectoRexEntity> vectoRexEntityMap;
    private DB db;

    public VectoRexClient(String uri) {
        if (VectorDB.mapDBManager == null) {
            if (uri == null) {
                new VectorDB("vectorex/vectorex.db");
            } else {
                new VectorDB(uri);
            }
        }
        this.db = VectorDB.mapDBManager.getDb();
        this.vectoRexEntityMap = this.db.hashMap("VectoRexCollections").createOrOpen();
    }

    public void createCollection(VectoRexEntity milvusEntity) {
        List vectorFileds = milvusEntity.getVectorFileds().stream().map(KeyValue::getValue).collect(Collectors.toList());
        VectorDB.createCollection((String)milvusEntity.getCollectionName(), (int)maxDataCount, vectorFileds);
        this.vectoRexEntityMap.put((Object)milvusEntity.getCollectionName(), (Object)milvusEntity);
        this.db.commit();
    }

    public void delCollection(String collection) {
        VectorDB.delCollection((String)collection);
        this.vectoRexEntityMap.remove((Object)collection);
        this.db.commit();
    }

    public MapDBStorage getStore(String collection) {
        MapDBStorage dataStore = VectorDB.getDataStore((String)collection);
        return dataStore;
    }

    public List<VectoRexEntity> getCollections() {
        return this.vectoRexEntityMap.values().stream().collect(Collectors.toList());
    }

    public VectoRexEntity getCollection(String collection) {
        return (VectoRexEntity)this.vectoRexEntityMap.get((Object)collection);
    }
}

