/*
 * Decompiled with CFR 0.152.
 */
package io.github.javpower.vectorexcore.converter;

import io.github.javpower.vectorex.keynote.model.VectorFiled;
import io.github.javpower.vectorexcore.annotation.VectoRexCollection;
import io.github.javpower.vectorexcore.annotation.VectoRexField;
import io.github.javpower.vectorexcore.cache.VecroRexCache;
import io.github.javpower.vectorexcore.entity.DataType;
import io.github.javpower.vectorexcore.entity.KeyValue;
import io.github.javpower.vectorexcore.entity.ScalarField;
import io.github.javpower.vectorexcore.entity.VectoRexEntity;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VecroRexConverter {
    private static final Logger log = LoggerFactory.getLogger(VecroRexConverter.class);

    public static VectoRexEntity convert(Class<?> entityClass) {
        VectoRexEntity cache = VecroRexCache.rexCache.get(entityClass.getName());
        if (Objects.nonNull(cache)) {
            return cache;
        }
        VectoRexEntity vectoRex = new VectoRexEntity();
        ArrayList<KeyValue<String, VectorFiled>> vectorFileds = new ArrayList<KeyValue<String, VectorFiled>>();
        ArrayList<KeyValue<String, ScalarField>> scalarFields = new ArrayList<KeyValue<String, ScalarField>>();
        VectoRexCollection collectionAnnotation = entityClass.getAnnotation(VectoRexCollection.class);
        if (Objects.isNull(collectionAnnotation)) {
            throw new IllegalArgumentException("Entity must be annotated with @VectoRexCollection");
        }
        String collectionName = collectionAnnotation.name();
        vectoRex.setCollectionName(collectionName);
        List<Field> fields = VecroRexConverter.getAllFieldsFromClass(entityClass);
        HashMap<String, String> toField = new HashMap<String, String>();
        for (Field field : fields) {
            VectoRexField fieldAnnotation = field.getAnnotation(VectoRexField.class);
            if (Objects.isNull(fieldAnnotation)) continue;
            String fieldName = fieldAnnotation.name().isEmpty() ? field.getName() : fieldAnnotation.name();
            toField.put(fieldName, field.getName());
            if (fieldAnnotation.dataType().equals((Object)DataType.Scalar)) {
                ScalarField scalarField = new ScalarField();
                scalarField.setName(fieldName);
                scalarField.setIsPrimaryKey(fieldAnnotation.isPrimaryKey());
                KeyValue<String, ScalarField> keyValue = new KeyValue<String, ScalarField>(field.getName(), scalarField);
                scalarFields.add(keyValue);
                if (!fieldAnnotation.isPrimaryKey()) continue;
                VecroRexCache.primaryKey.put(entityClass.getName(), field.getName());
                continue;
            }
            boolean listFloat = VecroRexConverter.isListFloat(field);
            if (!listFloat) {
                throw new IllegalArgumentException("vector filed type err");
            }
            VectorFiled vectorFiled = new VectorFiled();
            vectorFiled.setName(fieldName);
            vectorFiled.setDimensions(fieldAnnotation.dimension());
            vectorFiled.setMetricType(fieldAnnotation.metricType());
            KeyValue<String, VectorFiled> keyValue = new KeyValue<String, VectorFiled>(field.getName(), vectorFiled);
            vectorFileds.add(keyValue);
        }
        vectoRex.setVectorFileds(vectorFileds);
        vectoRex.setScalarFields(scalarFields);
        if (VecroRexCache.primaryKey.get(entityClass.getName()) == null) {
            throw new IllegalArgumentException("the primary key does not null");
        }
        VecroRexCache.rexCache.put(entityClass.getName(), vectoRex);
        VecroRexCache.toField.put(entityClass.getName(), toField);
        return vectoRex;
    }

    public static List<Field> getAllFieldsFromClass(Class<?> clazz) {
        ArrayList<Field> fields = new ArrayList<Field>();
        while (clazz != null && clazz != Object.class) {
            fields.addAll(Stream.of(clazz.getDeclaredFields()).peek(field -> field.setAccessible(true)).collect(Collectors.toList()));
            clazz = clazz.getSuperclass();
        }
        return fields;
    }

    public static boolean isListFloat(Field field) {
        if (field == null) {
            return false;
        }
        Type genericType = field.getGenericType();
        if (!(genericType instanceof ParameterizedType)) {
            return false;
        }
        ParameterizedType parameterizedType = (ParameterizedType)genericType;
        Type rawType = parameterizedType.getRawType();
        if (!(rawType instanceof Class) || !List.class.isAssignableFrom((Class)rawType)) {
            return false;
        }
        Type[] typeArguments = parameterizedType.getActualTypeArguments();
        return typeArguments.length == 1 && typeArguments[0] == Float.class;
    }
}

