/*
 * Decompiled with CFR 0.152.
 */
package io.github.javpower.vectorexcore.service;

import io.github.javpower.vectorexcore.VectoRexClient;
import io.github.javpower.vectorexcore.annotation.VectoRexCollection;
import io.github.javpower.vectorexcore.converter.VecroRexConverter;
import io.github.javpower.vectorexcore.entity.VectoRexEntity;
import io.github.javpower.vectorexcore.model.VectoRexProperties;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractClientBuilder {
    private static final Logger log = LoggerFactory.getLogger(AbstractClientBuilder.class);
    protected VectoRexProperties properties;
    protected VectoRexClient client;
    private static final String CLASS = "*.class";

    public void initialize() {
        if (this.properties.isEnable()) {
            this.client = new VectoRexClient(this.properties.getUri());
            this.handler();
        }
    }

    public void handler() {
        List<Class<?>> classes;
        if (Objects.isNull(this.client)) {
            log.warn("initialize handler over!");
        }
        if ((classes = this.getClass(this.properties.getPackages())).isEmpty()) {
            log.warn("no any collections have been initialized, see if the [packages] parameter is configured correctly. :( !");
            return;
        }
        this.performBusinessLogic(classes);
    }

    public VectoRexClient getClient() {
        return this.client;
    }

    private List<Class<?>> getClass(List<String> packages) {
        return Optional.ofNullable(packages).orElseThrow(() -> new RuntimeException("model package is null, please configure the [packages] parameter")).stream().flatMap(pg -> this.scanPackageClasses((String)pg).stream()).filter(clazz -> clazz.getAnnotation(VectoRexCollection.class) != null).collect(Collectors.toList());
    }

    private List<Class<?>> scanPackageClasses(String basePackage) {
        Enumeration<URL> resources;
        String path = basePackage.replace('.', '/');
        try {
            resources = Thread.currentThread().getContextClassLoader().getResources(path);
        }
        catch (IOException e) {
            throw new RuntimeException("Scan package failed: " + basePackage, e);
        }
        ArrayList classes = new ArrayList();
        while (resources.hasMoreElements()) {
            URL resource = resources.nextElement();
            classes.addAll(this.scanDirectory(new File(resource.getFile().replaceAll("%20", " ")), basePackage));
        }
        return classes;
    }

    private List<Class<?>> scanDirectory(File directory, String packageName) {
        ArrayList classes = new ArrayList();
        if (!directory.exists()) {
            return classes;
        }
        File[] files = directory.listFiles();
        if (files == null) {
            return classes;
        }
        for (File file : files) {
            if (file.isDirectory()) {
                classes.addAll(this.scanDirectory(file, packageName + "." + file.getName()));
                continue;
            }
            if (!file.getName().endsWith(".class")) continue;
            String className = packageName + '.' + file.getName().substring(0, file.getName().length() - 6);
            try {
                classes.add(Class.forName(className));
            }
            catch (ClassNotFoundException e) {
                log.warn("Class not found: {}", (Object)className);
            }
        }
        return classes;
    }

    public void performBusinessLogic(List<Class<?>> annotatedClasses) {
        for (Class<?> milvusClass : annotatedClasses) {
            VectoRexEntity milvusEntity = VecroRexConverter.convert(milvusClass);
            this.client.createCollection(milvusEntity);
        }
    }

    public void setProperties(VectoRexProperties properties) {
        this.properties = properties;
    }
}

