/*
 * Decompiled with CFR 0.152.
 */
package io.github.linpeilie.processor;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.TypeName;
import io.github.linpeilie.annotations.AutoEnumMapper;
import io.github.linpeilie.annotations.AutoMapMapper;
import io.github.linpeilie.annotations.AutoMapper;
import io.github.linpeilie.annotations.AutoMappers;
import io.github.linpeilie.annotations.AutoMapping;
import io.github.linpeilie.annotations.AutoMappings;
import io.github.linpeilie.annotations.ComponentModelConfig;
import io.github.linpeilie.annotations.MapperConfig;
import io.github.linpeilie.annotations.ReverseAutoMapping;
import io.github.linpeilie.annotations.ReverseAutoMappings;
import io.github.linpeilie.processor.AbstractAdapterMapperGenerator;
import io.github.linpeilie.processor.AutoMapperProperties;
import io.github.linpeilie.processor.DuplicateMapperException;
import io.github.linpeilie.processor.ProcessorOptions;
import io.github.linpeilie.processor.generator.AutoEnumMapperGenerator;
import io.github.linpeilie.processor.generator.AutoMapperGenerator;
import io.github.linpeilie.processor.generator.DefaultAdapterMapperGenerator;
import io.github.linpeilie.processor.generator.MapperConfigGenerator;
import io.github.linpeilie.processor.generator.SolonAdapterMapperGenerator;
import io.github.linpeilie.processor.generator.SpringAdapterMapperGenerator;
import io.github.linpeilie.processor.metadata.AbstractAdapterMethodMetadata;
import io.github.linpeilie.processor.metadata.AdapterEnumMethodMetadata;
import io.github.linpeilie.processor.metadata.AdapterMapMethodMetadata;
import io.github.linpeilie.processor.metadata.AdapterMethodMetadata;
import io.github.linpeilie.processor.metadata.AutoEnumMapperMetadata;
import io.github.linpeilie.processor.metadata.AutoMapMapperMetadata;
import io.github.linpeilie.processor.metadata.AutoMapperMetadata;
import io.github.linpeilie.processor.metadata.AutoMappingMetadata;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedOptions;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.MirroredTypeException;
import javax.lang.model.type.MirroredTypesException;
import javax.lang.model.type.TypeMirror;
import javax.tools.Diagnostic;

@SupportedAnnotationTypes(value={"io.github.linpeilie.annotations.AutoMapper", "io.github.linpeilie.annotations.AutoMappers", "io.github.linpeilie.annotations.AutoMapMapper", "io.github.linpeilie.annotations.AutoEnumMapper", "io.github.linpeilie.annotations.MapperConfig", "io.github.linpeilie.annotations.ComponentModelConfig", "org.mapstruct.Mapper"})
@SupportedOptions(value={"mapstruct.plus.mapperConfigClass", "mapstruct.plus.mapperPackage", "mapstruct.plus.unmappedSourcePolicy", "mapstruct.plus.unmappedTargetPolicy", "mapstruct.plus.nullValueMappingStrategy", "mapstruct.plus.nullValuePropertyMappingStrategy", "mapstruct.plus.builder.buildMethod", "mapstruct.plus.builder.disableBuilder", "mapstruct.plus.adapterPackage", "mapstruct.plus.adapterClassName", "mapstruct.plus.mapAdapterClassName"})
public class AutoMapperProcessor
extends AbstractProcessor {
    private static final ClassName MAPPING_DEFAULT_TARGET = ClassName.get((String)"io.github.linpeilie", (String)"DefaultMapping", (String[])new String[0]);
    private final AutoMapperGenerator mapperGenerator;
    private AbstractAdapterMapperGenerator adapterMapperGenerator;
    private final MapperConfigGenerator mapperConfigGenerator;
    private final Map<String, AbstractAdapterMethodMetadata> methodMap = new HashMap<String, AbstractAdapterMethodMetadata>();
    private final Map<String, AbstractAdapterMethodMetadata> mapMethodMap = new HashMap<String, AbstractAdapterMethodMetadata>();
    private final List<AutoMapperMetadata> mapperList = new ArrayList<AutoMapperMetadata>();
    private final List<TypeMirror> customMapperList = new ArrayList<TypeMirror>();
    private final Set<String> mapperSet = new HashSet<String>();

    public AutoMapperProcessor() {
        this.mapperGenerator = new AutoMapperGenerator();
        this.mapperConfigGenerator = new MapperConfigGenerator();
    }

    private boolean isAutoMapperAnnotation(TypeElement annotation) {
        return "io.github.linpeilie.annotations.AutoMapper".contentEquals(annotation.getQualifiedName());
    }

    private boolean isAutoMappersAnnotation(TypeElement annotation) {
        return "io.github.linpeilie.annotations.AutoMappers".contentEquals(annotation.getQualifiedName());
    }

    private boolean isAutoMapMapperAnnotation(TypeElement annotation) {
        return "io.github.linpeilie.annotations.AutoMapMapper".contentEquals(annotation.getQualifiedName());
    }

    private boolean isAutoEnumMapperAnnotation(TypeElement annotation) {
        return "io.github.linpeilie.annotations.AutoEnumMapper".contentEquals(annotation.getQualifiedName());
    }

    private boolean isMapperConfigAnnotation(TypeElement annotation) {
        return "io.github.linpeilie.annotations.MapperConfig".contentEquals(annotation.getQualifiedName());
    }

    private boolean isMapperAnnotation(TypeElement annotation) {
        return "org.mapstruct.Mapper".contentEquals(annotation.getQualifiedName());
    }

    private boolean isComponentModelConfigAnnotation(TypeElement annotation) {
        return "io.github.linpeilie.annotations.ComponentModelConfig".contentEquals(annotation.getQualifiedName());
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        boolean hasAutoMapper = annotations.stream().anyMatch(this::isAutoMapperAnnotation);
        boolean hasAutoMapMapper = annotations.stream().anyMatch(this::isAutoMapMapperAnnotation);
        boolean hasAutoEnumMapper = annotations.stream().anyMatch(this::isAutoEnumMapperAnnotation);
        boolean hasAutoMapMappers = annotations.stream().anyMatch(this::isAutoMappersAnnotation);
        if (!(hasAutoMapper || hasAutoMapMapper || hasAutoEnumMapper || hasAutoMapMappers)) {
            return false;
        }
        this.refreshProperties(annotations, roundEnv);
        switch (AutoMapperProperties.getComponentModel()) {
            case "spring": {
                this.adapterMapperGenerator = new SpringAdapterMapperGenerator();
                break;
            }
            case "solon": {
                this.adapterMapperGenerator = new SolonAdapterMapperGenerator();
                break;
            }
            default: {
                this.adapterMapperGenerator = new DefaultAdapterMapperGenerator();
            }
        }
        annotations.stream().filter(this::isAutoMapMapperAnnotation).findFirst().ifPresent(annotation -> this.processAutoMapMapperAnnotation(roundEnv, (TypeElement)annotation));
        annotations.stream().filter(this::isAutoEnumMapperAnnotation).findFirst().ifPresent(annotation -> this.processAutoEnumMapperAnnotation(roundEnv, (TypeElement)annotation));
        annotations.stream().filter(this::isAutoMapperAnnotation).findFirst().ifPresent(annotation -> this.processAutoMapperAnnotation(roundEnv, (TypeElement)annotation));
        annotations.stream().filter(this::isAutoMappersAnnotation).findFirst().ifPresent(annotation -> this.processAutoMappersAnnotation(roundEnv, (TypeElement)annotation));
        annotations.stream().filter(this::isMapperAnnotation).findFirst().ifPresent(annotation -> this.processMapperAnnotation(roundEnv, (TypeElement)annotation));
        this.generateMapper();
        return false;
    }

    private void processMapperAnnotation(RoundEnvironment roundEnv, TypeElement annotation) {
        roundEnv.getElementsAnnotatedWith(annotation).forEach(element -> this.customMapperList.add(element.asType()));
    }

    private void processAutoEnumMapperAnnotation(RoundEnvironment roundEnv, TypeElement annotation) {
        roundEnv.getElementsAnnotatedWith(annotation).stream().map(this::buildAutoEnumMapperMetadata).filter(Objects::nonNull).forEach(this::writeAutoEnumMapperFile);
    }

    private void writeAutoEnumMapperFile(AutoEnumMapperMetadata autoEnumMapperMetadata) {
        AutoEnumMapperGenerator autoEnumMapperGenerator = new AutoEnumMapperGenerator();
        try (Writer writer = this.processingEnv.getFiler().createSourceFile(autoEnumMapperMetadata.mapperPackage() + "." + autoEnumMapperMetadata.mapperName(), new Element[0]).openWriter();){
            autoEnumMapperGenerator.write(autoEnumMapperMetadata, writer);
        }
        catch (IOException e) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Error while opening " + autoEnumMapperMetadata.mapperName() + " output file : " + e.getMessage());
        }
        this.addAdapterMethodMetadata(autoEnumMapperMetadata);
    }

    private void addAdapterMethodMetadata(AutoEnumMapperMetadata autoEnumMapperMetadata) {
        AdapterEnumMethodMetadata toValueProxyMethod = new AdapterEnumMethodMetadata((TypeName)autoEnumMapperMetadata.getSourceClassName(), ClassName.get((String)autoEnumMapperMetadata.mapperPackage(), (String)autoEnumMapperMetadata.mapperName(), (String[])new String[0]), autoEnumMapperMetadata.toValueMethodName(), autoEnumMapperMetadata.getReturnType());
        AdapterEnumMethodMetadata toEnumProxyMethod = new AdapterEnumMethodMetadata(autoEnumMapperMetadata.getReturnType(), ClassName.get((String)autoEnumMapperMetadata.mapperPackage(), (String)autoEnumMapperMetadata.mapperName(), (String[])new String[0]), autoEnumMapperMetadata.toEnumMethodName(), (TypeName)autoEnumMapperMetadata.getSourceClassName());
        this.methodMap.put(autoEnumMapperMetadata.getSourceClassName().simpleName() + toValueProxyMethod.getMapperMethodName(), toValueProxyMethod);
        this.methodMap.put(autoEnumMapperMetadata.getSourceClassName().simpleName() + toEnumProxyMethod.getMapperMethodName(), toEnumProxyMethod);
    }

    private AutoEnumMapperMetadata buildAutoEnumMapperMetadata(Element element) {
        AutoEnumMapper autoEnumMapper = element.getAnnotation(AutoEnumMapper.class);
        ClassName enumClassName = ClassName.get((TypeElement)((TypeElement)element));
        String enumCodeFieldName = autoEnumMapper.value();
        Element enumCodeGetterElement = null;
        List<? extends Element> enclosedElements = element.getEnclosedElements();
        for (Element element2 : enclosedElements) {
            boolean isGetter;
            if (!ElementKind.METHOD.equals((Object)element2.getKind()) || !(isGetter = StrUtil.equalsIgnoreCase((CharSequence)element2.getSimpleName(), (CharSequence)("get" + enumCodeFieldName)) || StrUtil.equalsIgnoreCase((CharSequence)element2.getSimpleName(), (CharSequence)("is" + enumCodeFieldName)))) continue;
            enumCodeGetterElement = element2;
            break;
        }
        if (enumCodeGetterElement == null) {
            return null;
        }
        String getter = enumCodeGetterElement.getSimpleName().toString();
        TypeName typeName = TypeName.get((TypeMirror)((ExecutableElement)enumCodeGetterElement).getReturnType());
        AutoEnumMapperMetadata autoEnumMapperMetadata = new AutoEnumMapperMetadata();
        autoEnumMapperMetadata.setSourceClassName(enumClassName);
        autoEnumMapperMetadata.setGetter(getter);
        autoEnumMapperMetadata.setReturnType(typeName);
        return autoEnumMapperMetadata;
    }

    private void processAutoMapMapperAnnotation(RoundEnvironment roundEnv, TypeElement annotation) {
        List<AutoMapperMetadata> autoMapMapperMetadataList = roundEnv.getElementsAnnotatedWith(annotation).stream().map(ele -> {
            if (ele.getAnnotation(AutoMapMapper.class) == null) {
                return null;
            }
            ClassName source = ClassName.get((String)"java.util", (String)"Map", (String[])new String[0]);
            ClassName target = ClassName.get((TypeElement)((TypeElement)ele));
            List<ClassName> uses = Arrays.asList(ClassName.get((String)"io.github.linpeilie.map", (String)"MapObjectConvert", (String[])new String[0]));
            AutoMapMapperMetadata autoMapperMetadata = new AutoMapMapperMetadata();
            autoMapperMetadata.setTargetClassName(target);
            autoMapperMetadata.setSourceClassName(source);
            autoMapperMetadata.setUsesClassNameList(uses);
            autoMapperMetadata.setSuperClass(ClassName.get((String)"io.github.linpeilie", (String)"BaseMapMapper", (String[])new String[0]));
            autoMapperMetadata.setSuperGenerics(new ClassName[]{target});
            autoMapperMetadata.setMapstructConfigClass(ClassName.get((String)AutoMapperProperties.getConfigPackage(), (String)AutoMapperProperties.getMapConfigClassName(), (String[])new String[0]));
            return autoMapperMetadata;
        }).filter(Objects::nonNull).collect(Collectors.toList());
        autoMapMapperMetadataList.forEach(metadata -> {
            this.writeAutoMapperClassFile((AutoMapperMetadata)metadata);
            this.addAdapterMapMethod(metadata.getSourceClassName(), metadata.getTargetClassName(), metadata.mapperClass(), false);
            this.addAdapterMapMethod(ClassName.get((String)"java.lang", (String)"Object", (String[])new String[0]), metadata.getTargetClassName(), metadata.mapperClass(), true);
        });
        this.adapterMapperGenerator.write(this.processingEnv, this.mapMethodMap.values(), AutoMapperProperties.getMapAdapterClassName());
        this.mapperConfigGenerator.write(this.processingEnv, AutoMapperProperties.getMapConfigClassName(), AutoMapperProperties.getMapAdapterClassName(), null);
    }

    private void loadMapperConfig(MapperConfig mapperConfig) {
        if (mapperConfig == null) {
            return;
        }
        AutoMapperProperties.setUnmappedSourcePolicy(mapperConfig.unmappedSourcePolicy());
        AutoMapperProperties.setUnmappedTargetPolicy(mapperConfig.unmappedTargetPolicy());
        AutoMapperProperties.setNullValueMappingStrategy(mapperConfig.nullValueMappingStrategy());
        AutoMapperProperties.setNullValuePropertyMappingStrategy(mapperConfig.nullValuePropertyMappingStrategy());
        AutoMapperProperties.setBuildMethod(mapperConfig.builder().buildMethod());
        AutoMapperProperties.setDisableBuilder(mapperConfig.builder().disableBuilder());
        if (StrUtil.isNotEmpty((CharSequence)mapperConfig.mapperPackage())) {
            AutoMapperProperties.setMapperPackage(mapperConfig.mapperPackage());
        }
        if (StrUtil.isNotEmpty((CharSequence)mapperConfig.adapterPackage())) {
            AutoMapperProperties.setAdapterPackage(mapperConfig.adapterPackage());
        }
        if (StrUtil.isNotEmpty((CharSequence)mapperConfig.adapterClassName())) {
            AutoMapperProperties.setAdapterClassName(mapperConfig.adapterClassName());
        }
        if (StrUtil.isNotEmpty((CharSequence)mapperConfig.mapAdapterClassName())) {
            AutoMapperProperties.setMapAdapterClassName(mapperConfig.mapAdapterClassName());
        }
    }

    private void refreshProperties(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        TypeElement typeElement;
        annotations.stream().filter(this::isMapperConfigAnnotation).findFirst().flatMap(annotation -> roundEnv.getElementsAnnotatedWith((TypeElement)annotation).stream().findFirst()).ifPresent(element -> this.loadMapperConfig(element.getAnnotation(MapperConfig.class)));
        String mapperConfigClass = this.processingEnv.getOptions().get("mapstruct.plus.mapperConfigClass");
        if (StrUtil.isNotEmpty((CharSequence)mapperConfigClass) && (typeElement = this.processingEnv.getElementUtils().getTypeElement(mapperConfigClass)) != null) {
            this.loadMapperConfig(typeElement.getAnnotation(MapperConfig.class));
        }
        annotations.stream().filter(this::isComponentModelConfigAnnotation).findFirst().flatMap(annotation -> roundEnv.getElementsAnnotatedWith((TypeElement)annotation).stream().findFirst()).ifPresent(element -> {
            ComponentModelConfig componentModelConfig = element.getAnnotation(ComponentModelConfig.class);
            String componentModelByAnnotation = componentModelConfig.componentModel();
            AutoMapperProperties.setComponentModel(componentModelByAnnotation);
        });
        this.loadCompilerArgs();
    }

    private void loadCompilerArgs() {
        ProcessorOptions.optionConsumers().forEach((key, consumer) -> {
            String value = this.processingEnv.getOptions().get(key);
            if (StrUtil.isNotEmpty((CharSequence)value)) {
                consumer.accept(value);
            }
        });
    }

    private void processAutoMapperAnnotation(RoundEnvironment roundEnv, TypeElement annotation) {
        List autoMapperMetadataList = roundEnv.getElementsAnnotatedWith(annotation).stream().map(this::buildAutoMapperMetadata).filter(Objects::nonNull).collect(Collectors.toList());
        this.mapperList.addAll(autoMapperMetadataList);
    }

    private void processAutoMappersAnnotation(RoundEnvironment roundEnv, TypeElement annotation) {
        List autoMapperMetadata = roundEnv.getElementsAnnotatedWith(annotation).stream().map(this::buildAutoMapperMetadataByAutoMappers).filter(Objects::nonNull).flatMap(Collection::stream).collect(Collectors.toList());
        this.mapperList.addAll(autoMapperMetadata);
    }

    private void generateMapper() {
        ArrayList reverseMapperMetadataList = new ArrayList();
        this.mapperList.forEach(autoMapperMetadata -> {
            if (!autoMapperMetadata.isReverseConvertGenerate()) {
                return;
            }
            boolean defineReverseMapping = CollectionUtil.isNotEmpty(autoMapperMetadata.getFieldReverseMappingList());
            AutoMapperMetadata reverseMapperMetadata = this.reverseMapper((AutoMapperMetadata)autoMapperMetadata);
            if (defineReverseMapping) {
                this.addMapper(reverseMapperMetadata);
            } else if (!this.mapperSet.add(reverseMapperMetadata.mapperName())) {
                return;
            }
            reverseMapperMetadataList.add(reverseMapperMetadata);
        });
        this.mapperList.addAll(reverseMapperMetadataList);
        this.mapperList.forEach(metadata -> {
            if (!metadata.isConvertGenerate()) {
                return;
            }
            this.writeAutoMapperClassFile((AutoMapperMetadata)metadata);
            this.addAdapterMethod(metadata.getSourceClassName(), metadata.getTargetClassName(), metadata.mapperClass());
        });
        this.adapterMapperGenerator.write(this.processingEnv, this.methodMap.values(), AutoMapperProperties.getAdapterClassName());
        this.mapperConfigGenerator.write(this.processingEnv, AutoMapperProperties.getConfigClassName(), AutoMapperProperties.getAdapterClassName(), this.customMapperList);
    }

    private AutoMapperMetadata reverseMapper(AutoMapperMetadata autoMapperMetadata) {
        AutoMapperMetadata reverseMapperMetadata = this.initAutoMapperMetadata(autoMapperMetadata.getTargetClassName(), autoMapperMetadata.getSourceClassName());
        reverseMapperMetadata.setConvertGenerate(autoMapperMetadata.isReverseConvertGenerate());
        reverseMapperMetadata.setUsesClassNameList(autoMapperMetadata.getUsesClassNameList());
        reverseMapperMetadata.setImportsClassNameList(autoMapperMetadata.getImportsClassNameList());
        reverseMapperMetadata.setMapstructConfigClass(ClassName.get((String)AutoMapperProperties.getConfigPackage(), (String)AutoMapperProperties.getConfigClassName(), (String[])new String[0]));
        if (CollectionUtil.isNotEmpty(autoMapperMetadata.getFieldReverseMappingList())) {
            reverseMapperMetadata.setFieldMappingList(autoMapperMetadata.getFieldReverseMappingList());
        } else {
            List<AutoMappingMetadata> fieldMetadataList = autoMapperMetadata.getFieldMappingList().stream().map(fieldMapping -> {
                AutoMappingMetadata autoMappingMetadata = new AutoMappingMetadata();
                autoMappingMetadata.setSource(fieldMapping.getTarget());
                autoMappingMetadata.setTarget(fieldMapping.getSource());
                return autoMappingMetadata;
            }).collect(Collectors.toList());
            reverseMapperMetadata.setFieldMappingList(fieldMetadataList);
        }
        return reverseMapperMetadata;
    }

    private void writeAutoMapperClassFile(AutoMapperMetadata metadata) {
        String mapperPackage = metadata.mapperPackage();
        String mapperClassName = metadata.mapperName();
        try (Writer writer = this.processingEnv.getFiler().createSourceFile(mapperPackage + "." + mapperClassName, new Element[0]).openWriter();){
            this.mapperGenerator.write(metadata, writer);
        }
        catch (IOException e) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Error while opening " + metadata.mapperName() + " output file: " + e.getMessage());
        }
    }

    private void addAdapterMethod(ClassName source, ClassName target, ClassName mapper) {
        AdapterMethodMetadata adapterMethodMetadata = AdapterMethodMetadata.newInstance(source, target, mapper);
        this.methodMap.put(adapterMethodMetadata.getMethodName(), adapterMethodMetadata);
    }

    private void addAdapterMapMethod(ClassName source, ClassName target, ClassName mapper, boolean objectConverter) {
        AdapterMapMethodMetadata adapterMapMethodMetadata = new AdapterMapMethodMetadata(source, target, mapper, objectConverter);
        this.mapMethodMap.put(adapterMapMethodMetadata.getMethodName(), adapterMapMethodMetadata);
    }

    private AutoMapperMetadata initAutoMapperMetadata(ClassName source, ClassName target) {
        AutoMapperMetadata metadata = new AutoMapperMetadata();
        metadata.setSourceClassName(source);
        metadata.setTargetClassName(target);
        metadata.setSuperClass(ClassName.get((String)"io.github.linpeilie", (String)"BaseMapper", (String[])new String[0]));
        metadata.setSuperGenerics(new ClassName[]{source, target});
        metadata.setMapstructConfigClass(ClassName.get((String)AutoMapperProperties.getConfigPackage(), (String)AutoMapperProperties.getConfigClassName(), (String[])new String[0]));
        return metadata;
    }

    private List<AutoMapperMetadata> buildAutoMapperMetadataByAutoMappers(Element ele) {
        AutoMappers autoMappers = ele.getAnnotation(AutoMappers.class);
        if (autoMappers == null) {
            return null;
        }
        HashSet targetClassNames = new HashSet();
        return Arrays.stream(autoMappers.value()).filter(autoMapper -> {
            ClassName className = this.transToClassName(() -> ((AutoMapper)autoMapper).target());
            if (className == null) {
                return false;
            }
            return targetClassNames.add(className.reflectionName());
        }).map(autoMapper -> this.buildAutoMapperMetadata((AutoMapper)autoMapper, ele)).collect(Collectors.toList());
    }

    private AutoMapperMetadata buildAutoMapperMetadata(Element ele) {
        AutoMapper autoMapperAnnotation = ele.getAnnotation(AutoMapper.class);
        if (autoMapperAnnotation == null) {
            return null;
        }
        return this.buildAutoMapperMetadata(autoMapperAnnotation, ele);
    }

    private boolean isTargetFieldMapping(ClassName target, AutoMappingMetadata mappingMetadata) {
        if (MAPPING_DEFAULT_TARGET.reflectionName().contentEquals(mappingMetadata.getTargetClass().reflectionName())) {
            return true;
        }
        return target.reflectionName().contentEquals(mappingMetadata.getTargetClass().reflectionName());
    }

    private AutoMapperMetadata buildAutoMapperMetadata(AutoMapper autoMapper, Element ele) {
        ClassName source = ClassName.get((TypeElement)((TypeElement)ele));
        ClassName target = this.transToClassName(() -> ((AutoMapper)autoMapper).target());
        if (target == null) {
            return null;
        }
        List<ClassName> uses = this.transToClassNameList(() -> ((AutoMapper)autoMapper).uses());
        List<ClassName> importsClassNameList = this.transToClassNameList(() -> ((AutoMapper)autoMapper).imports());
        List<AutoMappingMetadata> autoMappingMetadataList = this.buildFieldMappingMetadata((TypeElement)ele);
        autoMappingMetadataList.removeIf(mappingMetadata -> !this.isTargetFieldMapping(target, (AutoMappingMetadata)mappingMetadata));
        List<AutoMappingMetadata> reverseMappingMetadataList = this.buildFieldReverseMappingMetadata((TypeElement)ele);
        reverseMappingMetadataList.removeIf(mappingMetadata -> !this.isTargetFieldMapping(target, (AutoMappingMetadata)mappingMetadata));
        AutoMapperMetadata metadata = this.initAutoMapperMetadata(source, target);
        metadata.setUsesClassNameList(uses);
        metadata.setImportsClassNameList(importsClassNameList);
        metadata.setFieldMappingList(autoMappingMetadataList);
        metadata.setFieldReverseMappingList(reverseMappingMetadataList);
        metadata.setConvertGenerate(autoMapper.convertGenerate());
        metadata.setReverseConvertGenerate(autoMapper.reverseConvertGenerate());
        this.addMapper(metadata);
        return metadata;
    }

    private List<AutoMappingMetadata> buildFieldReverseMappingMetadata(TypeElement ele) {
        ArrayList<AutoMappingMetadata> list = new ArrayList<AutoMappingMetadata>();
        if (!ele.getKind().isClass()) {
            return list;
        }
        for (Element element : ele.getEnclosedElements()) {
            ReverseAutoMappings reverseAutoMappings;
            if (element.getKind() != ElementKind.FIELD) continue;
            ReverseAutoMapping reverseAutoMapping = element.getAnnotation(ReverseAutoMapping.class);
            if (reverseAutoMapping != null) {
                list.add(this.buildAutoMappingMetadata(reverseAutoMapping, element, ele));
            }
            if ((reverseAutoMappings = element.getAnnotation(ReverseAutoMappings.class)) == null) continue;
            for (ReverseAutoMapping mapping : reverseAutoMappings.value()) {
                list.add(this.buildAutoMappingMetadata(mapping, element, ele));
            }
        }
        list.removeIf(Objects::isNull);
        return list;
    }

    private AutoMappingMetadata buildAutoMappingMetadata(ReverseAutoMapping reverseAutoMapping, Element ele, TypeElement type) {
        ClassName targetClass = this.transToClassName(() -> ((ReverseAutoMapping)reverseAutoMapping).targetClass());
        if (targetClass == null) {
            return null;
        }
        AutoMappingMetadata metadata = new AutoMappingMetadata();
        if (StrUtil.isNotEmpty((CharSequence)reverseAutoMapping.source())) {
            metadata.setSource(reverseAutoMapping.source());
        } else {
            metadata.setSource(ele.getSimpleName().toString());
        }
        if (StrUtil.isNotEmpty((CharSequence)reverseAutoMapping.target())) {
            metadata.setTarget(reverseAutoMapping.target());
        } else {
            metadata.setTarget(ele.getSimpleName().toString());
        }
        metadata.setTargetClass(targetClass);
        metadata.setDefaultValue(reverseAutoMapping.defaultValue());
        metadata.setIgnore(reverseAutoMapping.ignore());
        metadata.setExpression(reverseAutoMapping.expression());
        metadata.setDateFormat(reverseAutoMapping.dateFormat());
        metadata.setNumberFormat(reverseAutoMapping.numberFormat());
        return metadata;
    }

    private void addMapper(AutoMapperMetadata metadata) {
        if (!this.mapperSet.add(metadata.mapperName())) {
            throw new DuplicateMapperException("An exception occurred to generate " + metadata.mapperName() + ", check the mapping configuration for " + metadata.getSourceClassName().reflectionName() + " or " + metadata.getTargetClassName().reflectionName());
        }
    }

    private List<AutoMappingMetadata> buildFieldMappingMetadata(TypeElement autoMapperEle) {
        ArrayList<AutoMappingMetadata> list = new ArrayList<AutoMappingMetadata>();
        if (!autoMapperEle.getKind().isClass()) {
            return list;
        }
        for (Element element : autoMapperEle.getEnclosedElements()) {
            AutoMappings autoMappings;
            if (element.getKind() != ElementKind.FIELD) continue;
            AutoMapping autoMapping = element.getAnnotation(AutoMapping.class);
            if (autoMapping != null) {
                list.add(this.buildAutoMappingMetadata(autoMapping, element, autoMapperEle));
            }
            if ((autoMappings = element.getAnnotation(AutoMappings.class)) == null) continue;
            for (AutoMapping autoMappingEle : autoMappings.value()) {
                list.add(this.buildAutoMappingMetadata(autoMappingEle, element, autoMapperEle));
            }
        }
        list.removeIf(Objects::isNull);
        return list;
    }

    private AutoMappingMetadata buildAutoMappingMetadata(AutoMapping autoMapping, Element ele, TypeElement type) {
        ClassName targetClass = this.transToClassName(() -> ((AutoMapping)autoMapping).targetClass());
        if (targetClass == null) {
            return null;
        }
        AutoMappingMetadata metadata = new AutoMappingMetadata();
        if (StrUtil.isNotEmpty((CharSequence)autoMapping.source())) {
            metadata.setSource(autoMapping.source());
        } else {
            metadata.setSource(ele.getSimpleName().toString());
        }
        if (StrUtil.isNotEmpty((CharSequence)autoMapping.target())) {
            metadata.setTarget(autoMapping.target());
        } else {
            metadata.setTarget(ele.getSimpleName().toString());
        }
        metadata.setTargetClass(targetClass);
        metadata.setDefaultValue(autoMapping.defaultValue());
        metadata.setIgnore(autoMapping.ignore());
        metadata.setExpression(autoMapping.expression());
        metadata.setDateFormat(autoMapping.dateFormat());
        metadata.setNumberFormat(autoMapping.numberFormat());
        return metadata;
    }

    private ClassName transToClassName(Supplier<Class<?>> classSupplier) {
        TypeMirror typeMirror = null;
        try {
            Class<?> clazz = classSupplier.get();
        }
        catch (MirroredTypeException e) {
            typeMirror = e.getTypeMirror();
        }
        if (typeMirror == null) {
            return null;
        }
        return (ClassName)ClassName.get((TypeMirror)typeMirror);
    }

    private List<ClassName> transToClassNameList(Supplier<Class<?>[]> classSuppler) {
        List<? extends TypeMirror> typeMirrors = null;
        try {
            Class<?>[] classArray = classSuppler.get();
        }
        catch (MirroredTypesException e) {
            typeMirrors = e.getTypeMirrors();
        }
        return typeMirrors.stream().map(typeMirror -> (ClassName)ClassName.get((TypeMirror)typeMirror)).collect(Collectors.toList());
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latestSupported();
    }
}

