/*
 * Decompiled with CFR 0.152.
 */
package com.robot.dict;

import com.robot.dict.DictBean;
import com.robot.dict.DictPool;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public interface Dict<T> {
    default public void init(T code, String text) {
        DictPool.putDict(this, code, text);
    }

    default public T getCode() {
        return (T)DictPool.getDict(this).getCode();
    }

    default public String getText() {
        return DictPool.getDict(this).getText();
    }

    public static <T> String getTextByCode(Class<? extends Dict<T>> clazz, T code) {
        return Stream.of(clazz.getEnumConstants()).filter(e -> e.getCode().equals(code)).map(Dict::getText).findAny().orElse(null);
    }

    public static <T> T getCodeByText(Class<? extends Dict<T>> clazz, String text) {
        return Stream.of(clazz.getEnumConstants()).filter(e -> e.getText().equals(text)).map(Dict::getCode).findAny().orElse(null);
    }

    public static <T, K extends Dict<T>> K getByCode(Class<K> clazz, T code) {
        return (K)((Dict)Stream.of(clazz.getEnumConstants()).filter(e -> e.getCode().toString().equals(String.valueOf(code))).findAny().orElse(null));
    }

    public static <T> List<DictBean> getAll(Class<? extends Dict<T>> clazz) {
        return Dict.getAll(clazz, false);
    }

    public static <T> List<DictBean> getAll(Class<? extends Dict<T>> clazz, boolean isExcludeDeprecated) {
        return DictPool.getAll(clazz, isExcludeDeprecated);
    }

    @SafeVarargs
    public static <E extends Dict<?>> List<DictBean> getItems(E ... enums) {
        return Stream.of(enums).map(DictPool::getDict).collect(Collectors.toList());
    }

    public static <E extends Dict<?>> List<DictBean> getItemsExclude(E ... excludeEnums) {
        Class<?> enmuClass = excludeEnums.getClass().getComponentType();
        List<DictBean> allDict = DictPool.getAll(enmuClass, false);
        List excluceCodeList = Stream.of(excludeEnums).map(Dict::getCode).collect(Collectors.toList());
        return allDict.stream().filter(dictBean -> !excluceCodeList.contains(dictBean.getCode())).collect(Collectors.toList());
    }

    public static <T, K> List<DictBean> parseList(List<T> list, Function<T, K> codeGenerator, Function<T, String> textGenerator) {
        return list.stream().map(v -> new DictBean(codeGenerator.apply(v), (String)textGenerator.apply(v))).collect(Collectors.toList());
    }
}

