/*
 * Decompiled with CFR 0.152.
 */
package com.robot.dict;

import com.robot.dict.Dict;
import com.robot.dict.DictBean;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;

interface DictPool {
    public static final Map<Dict<?>, DictBean> DICT_MAP = new ConcurrentHashMap();
    public static final Map<Class<?>, List<DictBean>> DICT_CLASS_ITEMS_MAP = new ConcurrentHashMap();

    public static <T> void putDict(Dict<T> dict, T code, String text) {
        Class<?> dictClass = dict.getClass();
        boolean isEnumDeprecated = false;
        try {
            isEnumDeprecated = dictClass.getDeclaredField(((Enum)((Object)dict)).name()).isAnnotationPresent(Deprecated.class);
        }
        catch (ClassCastException | NoSuchFieldException e) {
            throw new RuntimeException(dictClass + "\u4e0d\u662f\u679a\u4e3e\u7c7b", e);
        }
        DictBean dictBean = new DictBean(code, text, isEnumDeprecated);
        DICT_MAP.put(dict, dictBean);
        DICT_CLASS_ITEMS_MAP.computeIfAbsent(dictClass, k -> new ArrayList()).add(dictBean);
    }

    public static DictBean getDict(Dict<?> dict) {
        return DICT_MAP.get(dict);
    }

    public static List<DictBean> getAll(Class<? extends Dict<?>> clazz, boolean isExcludeDeprecated) {
        clazz.getEnumConstants();
        List<DictBean> dictBeans = DICT_CLASS_ITEMS_MAP.get(clazz);
        if (isExcludeDeprecated) {
            return dictBeans.stream().filter(dictBean -> !dictBean.isDeprecated()).collect(Collectors.toList());
        }
        return dictBeans;
    }
}

