/*
 * Decompiled with CFR 0.152.
 */
package com.dtp.core.context;

import cn.hutool.core.collection.CollUtil;
import com.dtp.common.dto.NotifyItem;
import com.dtp.common.dto.NotifyPlatform;
import com.dtp.core.thread.DtpExecutor;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public class DtpContext {
    private DtpExecutor dtpExecutor;
    private List<NotifyPlatform> platforms;
    private NotifyItem notifyItem;

    public NotifyPlatform getPlatform(String platform) {
        if (CollUtil.isEmpty(this.platforms)) {
            return null;
        }
        Map map = this.platforms.stream().collect(Collectors.toMap(x -> x.getPlatform().toLowerCase(), Function.identity(), (v1, v2) -> v2));
        return (NotifyPlatform)map.get(platform.toLowerCase());
    }

    DtpContext(DtpExecutor dtpExecutor, List<NotifyPlatform> platforms, NotifyItem notifyItem) {
        this.dtpExecutor = dtpExecutor;
        this.platforms = platforms;
        this.notifyItem = notifyItem;
    }

    public static DtpContextBuilder builder() {
        return new DtpContextBuilder();
    }

    public DtpExecutor getDtpExecutor() {
        return this.dtpExecutor;
    }

    public List<NotifyPlatform> getPlatforms() {
        return this.platforms;
    }

    public NotifyItem getNotifyItem() {
        return this.notifyItem;
    }

    public void setDtpExecutor(DtpExecutor dtpExecutor) {
        this.dtpExecutor = dtpExecutor;
    }

    public void setPlatforms(List<NotifyPlatform> platforms) {
        this.platforms = platforms;
    }

    public void setNotifyItem(NotifyItem notifyItem) {
        this.notifyItem = notifyItem;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DtpContext)) {
            return false;
        }
        DtpContext other = (DtpContext)o;
        if (!other.canEqual(this)) {
            return false;
        }
        DtpExecutor this$dtpExecutor = this.getDtpExecutor();
        DtpExecutor other$dtpExecutor = other.getDtpExecutor();
        if (this$dtpExecutor == null ? other$dtpExecutor != null : !this$dtpExecutor.equals(other$dtpExecutor)) {
            return false;
        }
        List<NotifyPlatform> this$platforms = this.getPlatforms();
        List<NotifyPlatform> other$platforms = other.getPlatforms();
        if (this$platforms == null ? other$platforms != null : !((Object)this$platforms).equals(other$platforms)) {
            return false;
        }
        NotifyItem this$notifyItem = this.getNotifyItem();
        NotifyItem other$notifyItem = other.getNotifyItem();
        return !(this$notifyItem == null ? other$notifyItem != null : !this$notifyItem.equals(other$notifyItem));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DtpContext;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        DtpExecutor $dtpExecutor = this.getDtpExecutor();
        result = result * 59 + ($dtpExecutor == null ? 43 : $dtpExecutor.hashCode());
        List<NotifyPlatform> $platforms = this.getPlatforms();
        result = result * 59 + ($platforms == null ? 43 : ((Object)$platforms).hashCode());
        NotifyItem $notifyItem = this.getNotifyItem();
        result = result * 59 + ($notifyItem == null ? 43 : $notifyItem.hashCode());
        return result;
    }

    public String toString() {
        return "DtpContext(dtpExecutor=" + this.getDtpExecutor() + ", platforms=" + this.getPlatforms() + ", notifyItem=" + this.getNotifyItem() + ")";
    }

    public static class DtpContextBuilder {
        private DtpExecutor dtpExecutor;
        private List<NotifyPlatform> platforms;
        private NotifyItem notifyItem;

        DtpContextBuilder() {
        }

        public DtpContextBuilder dtpExecutor(DtpExecutor dtpExecutor) {
            this.dtpExecutor = dtpExecutor;
            return this;
        }

        public DtpContextBuilder platforms(List<NotifyPlatform> platforms) {
            this.platforms = platforms;
            return this;
        }

        public DtpContextBuilder notifyItem(NotifyItem notifyItem) {
            this.notifyItem = notifyItem;
            return this;
        }

        public DtpContext build() {
            return new DtpContext(this.dtpExecutor, this.platforms, this.notifyItem);
        }

        public String toString() {
            return "DtpContext.DtpContextBuilder(dtpExecutor=" + this.dtpExecutor + ", platforms=" + this.platforms + ", notifyItem=" + this.notifyItem + ")";
        }
    }
}

