/*
 * Decompiled with CFR 0.152.
 */
package com.dtp.core.notify;

import com.dtp.common.dto.NotifyItem;
import com.dtp.common.em.NotifyTypeEnum;
import com.dtp.core.thread.DtpExecutor;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;

public class AlarmLimiter {
    private static final Map<String, Cache<String, String>> ALARM_LIMITER = new ConcurrentHashMap<String, Cache<String, String>>();

    private AlarmLimiter() {
    }

    public static void initAlarmLimiter(String dtpName, NotifyItem notifyItem) {
        if (NotifyTypeEnum.CHANGE.getValue().equalsIgnoreCase(notifyItem.getType())) {
            return;
        }
        String outerKey = AlarmLimiter.buildOuterKey(dtpName, notifyItem.getType());
        Cache cache = CacheBuilder.newBuilder().expireAfterWrite((long)notifyItem.getInterval(), TimeUnit.SECONDS).build();
        ALARM_LIMITER.put(outerKey, (Cache<String, String>)cache);
    }

    public static void putVal(DtpExecutor executor, String type) {
        String outerKey = AlarmLimiter.buildOuterKey(executor.getThreadPoolName(), type);
        ALARM_LIMITER.get(outerKey).put((Object)type, (Object)type);
    }

    public static String getAlarmLimitInfo(String outerKey, String innerKey) {
        return (String)ALARM_LIMITER.get(outerKey).getIfPresent((Object)innerKey);
    }

    public static boolean ifAlarm(DtpExecutor executor, String type) {
        String key = AlarmLimiter.buildOuterKey(executor.getThreadPoolName(), type);
        return StringUtils.isBlank((CharSequence)AlarmLimiter.getAlarmLimitInfo(key, type));
    }

    public static String buildOuterKey(String dtpName, String type) {
        return dtpName + ":" + type;
    }
}

