/*
 * Decompiled with CFR 0.152.
 */
package com.dtp.core.notify.wechat;

import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpResponse;
import cn.hutool.json.JSONUtil;
import com.dtp.common.dto.MarkdownReq;
import com.dtp.common.dto.NotifyPlatform;
import com.dtp.core.notify.AbstractNotifier;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractWechatNotifier
extends AbstractNotifier {
    private static final Logger log = LoggerFactory.getLogger(AbstractWechatNotifier.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doSend(NotifyPlatform platform, String text) {
        String serverUrl = "https://qyapi.weixin.qq.com/cgi-bin/webhook/send?key=" + platform.getUrlKey();
        MarkdownReq markdownReq = new MarkdownReq();
        markdownReq.setMsgtype("markdown");
        MarkdownReq.Markdown markdown = new MarkdownReq.Markdown();
        markdown.setContent(text);
        markdownReq.setMarkdown(markdown);
        HttpResponse response = null;
        try {
            response = HttpRequest.post((String)serverUrl).body(JSONUtil.toJsonStr((Object)markdownReq)).execute();
        }
        catch (Exception e) {
            log.error("DynamicTp notify, wechat send fail...", (Throwable)e);
        }
        finally {
            if (Objects.nonNull(response)) {
                log.info("DynamicTp notify, wechat send success, response: {}, request:{}", (Object)response.body(), (Object)JSONUtil.toJsonStr((Object)markdownReq));
            }
        }
    }
}

