/*
 * Decompiled with CFR 0.152.
 */
package com.dtp.core.parser;

import com.dtp.common.em.ConfigFileTypeEnum;
import com.dtp.core.parser.AbstractConfigParser;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.config.YamlPropertiesFactoryBean;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.Resource;

public class YamlConfigParser
extends AbstractConfigParser {
    private static final List<ConfigFileTypeEnum> CONFIG_TYPE = Lists.newArrayList((Object[])new ConfigFileTypeEnum[]{ConfigFileTypeEnum.YML, ConfigFileTypeEnum.YAML});

    @Override
    public List<ConfigFileTypeEnum> type() {
        return CONFIG_TYPE;
    }

    @Override
    public Map<Object, Object> doParse(String content) {
        if (StringUtils.isEmpty((CharSequence)content)) {
            return Maps.newHashMapWithExpectedSize((int)0);
        }
        YamlPropertiesFactoryBean bean = new YamlPropertiesFactoryBean();
        bean.setResources(new Resource[]{new ByteArrayResource(content.getBytes())});
        return bean.getObject();
    }
}

