/*
 * Decompiled with CFR 0.152.
 */
package com.dtp.core.thread;

import com.dtp.common.dto.NotifyItem;
import com.dtp.core.reject.RejectHandlerGetter;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class DtpExecutor
extends ThreadPoolExecutor {
    private String threadPoolName;
    private final AtomicInteger rejectCount = new AtomicInteger();
    private String rejectHandlerName;
    private List<NotifyItem> notifyItems;

    public DtpExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, ThreadFactory threadFactory, RejectedExecutionHandler handler) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, threadFactory);
        this.rejectHandlerName = handler.getClass().getSimpleName();
        RejectedExecutionHandler rejectedExecutionHandler = RejectHandlerGetter.getProxy(handler);
        this.setRejectedExecutionHandler(rejectedExecutionHandler);
    }

    public void setThreadPoolName(String threadPoolName) {
        this.threadPoolName = threadPoolName;
    }

    public String getThreadPoolName() {
        return this.threadPoolName;
    }

    public void incRejectCount(int count) {
        this.rejectCount.addAndGet(count);
    }

    public int getRejectCount() {
        return this.rejectCount.get();
    }

    public List<NotifyItem> getNotifyItems() {
        return this.notifyItems;
    }

    public void setNotifyItems(List<NotifyItem> notifyItems) {
        this.notifyItems = notifyItems;
    }

    public String getQueueName() {
        return this.getQueue().getClass().getSimpleName();
    }

    public int getQueueCapacity() {
        return this.getQueue().size() + this.getQueue().remainingCapacity();
    }

    public String getRejectHandlerName() {
        return this.rejectHandlerName;
    }

    public void setRejectHandlerName(String rejectHandlerName) {
        this.rejectHandlerName = rejectHandlerName;
    }
}

