/*
 * Decompiled with CFR 0.152.
 */
package com.dtp.core.context;

import cn.hutool.core.collection.CollUtil;
import com.dtp.common.dto.AlarmInfo;
import com.dtp.common.dto.ExecutorWrapper;
import com.dtp.common.dto.NotifyItem;
import com.dtp.common.dto.NotifyPlatform;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public class DtpContext {
    private ExecutorWrapper executorWrapper;
    private List<NotifyPlatform> platforms;
    private NotifyItem notifyItem;
    private AlarmInfo alarmInfo;

    public NotifyPlatform getPlatform(String platform) {
        if (CollUtil.isEmpty(this.platforms)) {
            return null;
        }
        Map map = this.platforms.stream().collect(Collectors.toMap(x -> x.getPlatform().toLowerCase(), Function.identity(), (v1, v2) -> v2));
        return (NotifyPlatform)map.get(platform.toLowerCase());
    }

    DtpContext(ExecutorWrapper executorWrapper, List<NotifyPlatform> platforms, NotifyItem notifyItem, AlarmInfo alarmInfo) {
        this.executorWrapper = executorWrapper;
        this.platforms = platforms;
        this.notifyItem = notifyItem;
        this.alarmInfo = alarmInfo;
    }

    public static DtpContextBuilder builder() {
        return new DtpContextBuilder();
    }

    public ExecutorWrapper getExecutorWrapper() {
        return this.executorWrapper;
    }

    public List<NotifyPlatform> getPlatforms() {
        return this.platforms;
    }

    public NotifyItem getNotifyItem() {
        return this.notifyItem;
    }

    public AlarmInfo getAlarmInfo() {
        return this.alarmInfo;
    }

    public void setExecutorWrapper(ExecutorWrapper executorWrapper) {
        this.executorWrapper = executorWrapper;
    }

    public void setPlatforms(List<NotifyPlatform> platforms) {
        this.platforms = platforms;
    }

    public void setNotifyItem(NotifyItem notifyItem) {
        this.notifyItem = notifyItem;
    }

    public void setAlarmInfo(AlarmInfo alarmInfo) {
        this.alarmInfo = alarmInfo;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DtpContext)) {
            return false;
        }
        DtpContext other = (DtpContext)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ExecutorWrapper this$executorWrapper = this.getExecutorWrapper();
        ExecutorWrapper other$executorWrapper = other.getExecutorWrapper();
        if (this$executorWrapper == null ? other$executorWrapper != null : !this$executorWrapper.equals(other$executorWrapper)) {
            return false;
        }
        List<NotifyPlatform> this$platforms = this.getPlatforms();
        List<NotifyPlatform> other$platforms = other.getPlatforms();
        if (this$platforms == null ? other$platforms != null : !((Object)this$platforms).equals(other$platforms)) {
            return false;
        }
        NotifyItem this$notifyItem = this.getNotifyItem();
        NotifyItem other$notifyItem = other.getNotifyItem();
        if (this$notifyItem == null ? other$notifyItem != null : !this$notifyItem.equals(other$notifyItem)) {
            return false;
        }
        AlarmInfo this$alarmInfo = this.getAlarmInfo();
        AlarmInfo other$alarmInfo = other.getAlarmInfo();
        return !(this$alarmInfo == null ? other$alarmInfo != null : !this$alarmInfo.equals(other$alarmInfo));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DtpContext;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ExecutorWrapper $executorWrapper = this.getExecutorWrapper();
        result = result * 59 + ($executorWrapper == null ? 43 : $executorWrapper.hashCode());
        List<NotifyPlatform> $platforms = this.getPlatforms();
        result = result * 59 + ($platforms == null ? 43 : ((Object)$platforms).hashCode());
        NotifyItem $notifyItem = this.getNotifyItem();
        result = result * 59 + ($notifyItem == null ? 43 : $notifyItem.hashCode());
        AlarmInfo $alarmInfo = this.getAlarmInfo();
        result = result * 59 + ($alarmInfo == null ? 43 : $alarmInfo.hashCode());
        return result;
    }

    public String toString() {
        return "DtpContext(executorWrapper=" + this.getExecutorWrapper() + ", platforms=" + this.getPlatforms() + ", notifyItem=" + this.getNotifyItem() + ", alarmInfo=" + this.getAlarmInfo() + ")";
    }

    public static class DtpContextBuilder {
        private ExecutorWrapper executorWrapper;
        private List<NotifyPlatform> platforms;
        private NotifyItem notifyItem;
        private AlarmInfo alarmInfo;

        DtpContextBuilder() {
        }

        public DtpContextBuilder executorWrapper(ExecutorWrapper executorWrapper) {
            this.executorWrapper = executorWrapper;
            return this;
        }

        public DtpContextBuilder platforms(List<NotifyPlatform> platforms) {
            this.platforms = platforms;
            return this;
        }

        public DtpContextBuilder notifyItem(NotifyItem notifyItem) {
            this.notifyItem = notifyItem;
            return this;
        }

        public DtpContextBuilder alarmInfo(AlarmInfo alarmInfo) {
            this.alarmInfo = alarmInfo;
            return this;
        }

        public DtpContext build() {
            return new DtpContext(this.executorWrapper, this.platforms, this.notifyItem, this.alarmInfo);
        }

        public String toString() {
            return "DtpContext.DtpContextBuilder(executorWrapper=" + this.executorWrapper + ", platforms=" + this.platforms + ", notifyItem=" + this.notifyItem + ", alarmInfo=" + this.alarmInfo + ")";
        }
    }
}

