/*
 * Decompiled with CFR 0.152.
 */
package com.dtp.core.handler;

import com.dtp.common.dto.DtpMainProp;
import com.dtp.common.dto.NotifyItem;
import com.dtp.common.em.NotifyTypeEnum;
import com.dtp.core.context.DtpContextHolder;
import com.dtp.core.notify.Notifier;
import com.dtp.core.notify.ding.DtpDingNotifier;
import com.dtp.core.notify.lark.DtpLarkNotifier;
import com.dtp.core.notify.wechat.DtpWechatNotifier;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NotifierHandler {
    private static final Logger log = LoggerFactory.getLogger(NotifierHandler.class);
    private static final Map<String, Notifier> NOTIFIERS = new HashMap<String, Notifier>();

    private NotifierHandler() {
        ServiceLoader<Notifier> loader = ServiceLoader.load(Notifier.class);
        for (Notifier notifier : loader) {
            NOTIFIERS.put(notifier.platform(), notifier);
        }
        DtpDingNotifier dingNotifier = new DtpDingNotifier();
        DtpWechatNotifier wechatNotifier = new DtpWechatNotifier();
        DtpLarkNotifier larkNotifier = new DtpLarkNotifier();
        NOTIFIERS.put(dingNotifier.platform(), dingNotifier);
        NOTIFIERS.put(wechatNotifier.platform(), wechatNotifier);
        NOTIFIERS.put(larkNotifier.platform(), larkNotifier);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendNotice(DtpMainProp prop, List<String> diffs) {
        try {
            NotifyItem notifyItem = DtpContextHolder.get().getNotifyItem();
            for (String platform : notifyItem.getPlatforms()) {
                Notifier notifier = NOTIFIERS.get(platform.toLowerCase());
                if (notifier == null) continue;
                notifier.sendChangeMsg(prop, diffs);
            }
        }
        finally {
            DtpContextHolder.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendAlarm(NotifyTypeEnum typeEnum) {
        try {
            NotifyItem notifyItem = DtpContextHolder.get().getNotifyItem();
            for (String platform : notifyItem.getPlatforms()) {
                Notifier notifier = NOTIFIERS.get(platform.toLowerCase());
                if (notifier == null) continue;
                notifier.sendAlarmMsg(typeEnum);
            }
        }
        finally {
            DtpContextHolder.remove();
        }
    }

    public static NotifierHandler getInstance() {
        return NotifierHandlerHolder.INSTANCE;
    }

    private static class NotifierHandlerHolder {
        private static final NotifierHandler INSTANCE = new NotifierHandler();

        private NotifierHandlerHolder() {
        }
    }
}

