/*
 * Decompiled with CFR 0.152.
 */
package com.dtp.core.notify;

import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import com.dtp.common.ApplicationContextHolder;
import com.dtp.common.dto.AlarmInfo;
import com.dtp.common.dto.DtpMainProp;
import com.dtp.common.dto.Instance;
import com.dtp.common.dto.NotifyItem;
import com.dtp.common.dto.NotifyPlatform;
import com.dtp.common.em.NotifyPlatformEnum;
import com.dtp.common.em.NotifyTypeEnum;
import com.dtp.core.context.DtpContext;
import com.dtp.core.context.DtpContextHolder;
import com.dtp.core.notify.AlarmCounter;
import com.dtp.core.notify.Notifier;
import com.dtp.core.notify.NotifyHelper;
import com.dtp.core.thread.DtpExecutor;
import com.google.common.base.Joiner;
import java.lang.reflect.Field;
import java.net.InetAddress;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;

public abstract class AbstractNotifier
implements Notifier {
    private static final Logger log = LoggerFactory.getLogger(AbstractNotifier.class);
    private static Instance instance;

    public Instance getInstance() {
        return instance;
    }

    protected AbstractNotifier() {
        AbstractNotifier.init();
    }

    public static void init() {
        Environment environment = ApplicationContextHolder.getEnvironment();
        String appName = environment.getProperty("spring.application.name");
        appName = StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{appName}) ? appName : "application";
        String portStr = environment.getProperty("server.port");
        int port = StringUtils.isNotBlank((CharSequence)portStr) ? Integer.parseInt(portStr) : 0;
        String address = InetAddress.getLocalHost().getHostAddress();
        String[] profiles = environment.getActiveProfiles();
        if (profiles.length < 1) {
            profiles = environment.getDefaultProfiles();
        }
        instance = new Instance(address, port, appName, profiles[0]);
    }

    public String buildAlarmContent(NotifyPlatform platform, NotifyTypeEnum typeEnum, String template) {
        DtpContext context = DtpContextHolder.get();
        String threadPoolName = context.getExecutorWrapper().getThreadPoolName();
        ThreadPoolExecutor executor = (ThreadPoolExecutor)context.getExecutorWrapper().getExecutor();
        NotifyItem notifyItem = context.getNotifyItem();
        AlarmInfo alarmInfo = context.getAlarmInfo();
        Triple<String, String, String> triple = AlarmCounter.countRrq(threadPoolName, executor);
        String receivesStr = this.getReceives(platform.getPlatform(), platform.getReceivers());
        String content = String.format(template, this.getInstance().getServiceName(), this.getInstance().getIp() + ":" + this.getInstance().getPort(), this.getInstance().getEnv(), this.populatePoolName(threadPoolName, executor), typeEnum.getValue(), notifyItem.getThreshold(), executor.getCorePoolSize(), executor.getMaximumPoolSize(), executor.getPoolSize(), executor.getActiveCount(), executor.getLargestPoolSize(), executor.getTaskCount(), executor.getCompletedTaskCount(), executor.getQueue().size(), executor.getQueue().getClass().getSimpleName(), this.getQueueCapacity(executor), executor.getQueue().size(), executor.getQueue().remainingCapacity(), this.getRejectHandlerName(executor), triple.getLeft(), triple.getMiddle(), triple.getRight(), alarmInfo.getLastAlarmTime() == null ? "---" : alarmInfo.getLastAlarmTime(), DateUtil.now(), receivesStr, notifyItem.getInterval());
        return this.highlightAlarmContent(content, typeEnum);
    }

    public String buildNoticeContent(NotifyPlatform platform, String template, DtpMainProp oldProp, List<String> diffs) {
        String threadPoolName = oldProp.getThreadPoolName();
        DtpContext context = DtpContextHolder.get();
        ThreadPoolExecutor executor = (ThreadPoolExecutor)context.getExecutorWrapper().getExecutor();
        String receivesStr = this.getReceives(platform.getPlatform(), platform.getReceivers());
        String content = String.format(template, this.getInstance().getServiceName(), this.getInstance().getIp() + ":" + this.getInstance().getPort(), this.getInstance().getEnv(), this.populatePoolName(threadPoolName, executor), oldProp.getCorePoolSize(), executor.getCorePoolSize(), oldProp.getMaxPoolSize(), executor.getMaximumPoolSize(), oldProp.isAllowCoreThreadTimeOut(), executor.allowsCoreThreadTimeOut(), oldProp.getKeepAliveTime(), executor.getKeepAliveTime(TimeUnit.SECONDS), executor.getQueue().getClass().getSimpleName(), oldProp.getQueueCapacity(), this.getQueueCapacity(executor), oldProp.getRejectType(), this.getRejectHandlerName(executor), receivesStr, DateTime.now());
        return this.highlightNotifyContent(content, diffs);
    }

    private String getReceives(String platform, String receives) {
        if (StringUtils.isBlank((CharSequence)receives)) {
            return "";
        }
        if (NotifyPlatformEnum.LARK.name().toLowerCase().equals(platform)) {
            return Arrays.stream(receives.split(",")).map(receive -> StringUtils.startsWith((CharSequence)receive, (CharSequence)"ou_") ? String.format("<at id='%s'></at>", receive) : String.format("<at id=''>%s</at>", receive)).collect(Collectors.joining(" "));
        }
        Object[] receivers = StringUtils.split((String)receives, (char)',');
        return Joiner.on((String)", @").join(receivers);
    }

    protected abstract Pair<String, String> getColors();

    private String populatePoolName(String poolName, ThreadPoolExecutor executor) {
        String poolAlisaName = null;
        if (executor instanceof DtpExecutor) {
            poolAlisaName = ((DtpExecutor)executor).getTheadPoolAliasName();
        }
        if (StringUtils.isBlank(poolAlisaName)) {
            return poolName;
        }
        return poolName + "(" + poolAlisaName + ")";
    }

    private String getRejectHandlerName(ThreadPoolExecutor executor) {
        if (executor instanceof DtpExecutor) {
            return ((DtpExecutor)executor).getRejectHandlerName();
        }
        return executor.getRejectedExecutionHandler().getClass().getSimpleName();
    }

    private int getQueueCapacity(ThreadPoolExecutor executor) {
        if (executor instanceof DtpExecutor) {
            return ((DtpExecutor)executor).getQueueCapacity();
        }
        return executor.getQueue().size() + executor.getQueue().remainingCapacity();
    }

    private String highlightNotifyContent(String content, List<String> diffs) {
        if (StringUtils.isBlank((CharSequence)content)) {
            return content;
        }
        Pair<String, String> pair = this.getColors();
        for (String string : diffs) {
            content = content.replace(string, (CharSequence)pair.getLeft());
        }
        for (Field field : DtpMainProp.getMainProps()) {
            content = content.replace(field.getName(), (CharSequence)pair.getRight());
        }
        return content;
    }

    private String highlightAlarmContent(String content, NotifyTypeEnum typeEnum) {
        if (StringUtils.isBlank((CharSequence)content)) {
            return content;
        }
        Set<String> colorKeys = NotifyHelper.getAlarmKeys(typeEnum);
        Pair<String, String> pair = this.getColors();
        for (String field : colorKeys) {
            content = content.replace(field, (CharSequence)pair.getLeft());
        }
        for (String field : NotifyHelper.getAllAlarmKeys()) {
            content = content.replace(field, (CharSequence)pair.getRight());
        }
        return content;
    }
}

