/*
 * Decompiled with CFR 0.152.
 */
package com.dtp.core.notify;

import com.dtp.common.dto.AlarmInfo;
import com.dtp.common.em.NotifyTypeEnum;
import com.dtp.core.thread.DtpExecutor;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.commons.lang3.tuple.ImmutableTriple;
import org.apache.commons.lang3.tuple.Triple;

public class AlarmCounter {
    private static final Map<String, AlarmInfo> ALARM_INFO_CACHE = new ConcurrentHashMap<String, AlarmInfo>();

    private AlarmCounter() {
    }

    public static void init(String threadPoolName, String notifyType) {
        String key = AlarmCounter.buildKey(threadPoolName, notifyType);
        AlarmInfo alarmInfo = AlarmInfo.builder().type(NotifyTypeEnum.of((String)notifyType)).build();
        ALARM_INFO_CACHE.putIfAbsent(key, alarmInfo);
    }

    public static AlarmInfo getAlarmInfo(String threadPoolName, String notifyType) {
        String key = AlarmCounter.buildKey(threadPoolName, notifyType);
        return ALARM_INFO_CACHE.get(key);
    }

    public static void reset(String threadPoolName, String notifyType) {
        String key = AlarmCounter.buildKey(threadPoolName, notifyType);
        AlarmInfo alarmInfo = ALARM_INFO_CACHE.get(key);
        alarmInfo.reset();
    }

    public static void incAlarmCounter(String threadPoolName, String notifyType) {
        String key = AlarmCounter.buildKey(threadPoolName, notifyType);
        AlarmInfo alarmInfo = ALARM_INFO_CACHE.get(key);
        if (Objects.nonNull(alarmInfo)) {
            alarmInfo.incCounter();
        }
    }

    public static Triple<String, String, String> countRrq(String threadPoolName, ThreadPoolExecutor executor) {
        String queueTimeoutCount;
        String runTimeoutCount;
        String rejectCount;
        if (executor instanceof DtpExecutor) {
            AlarmInfo rejectAlarm = AlarmCounter.getAlarmInfo(threadPoolName, NotifyTypeEnum.REJECT.getValue());
            String leftCount = rejectAlarm == null ? "---" : String.valueOf(rejectAlarm.getCount());
            rejectCount = leftCount + " / " + ((DtpExecutor)executor).getRejectCount();
        } else {
            rejectCount = "--- / ---";
        }
        if (executor instanceof DtpExecutor) {
            AlarmInfo runTimeoutAlarm = AlarmCounter.getAlarmInfo(threadPoolName, NotifyTypeEnum.RUN_TIMEOUT.getValue());
            String leftCount = runTimeoutAlarm == null ? "---" : String.valueOf(runTimeoutAlarm.getCount());
            runTimeoutCount = leftCount + " / " + ((DtpExecutor)executor).getRunTimeoutCount();
        } else {
            runTimeoutCount = "--- / ---";
        }
        if (executor instanceof DtpExecutor) {
            AlarmInfo queueTimeoutAlarm = AlarmCounter.getAlarmInfo(threadPoolName, NotifyTypeEnum.QUEUE_TIMEOUT.getValue());
            String leftCount = queueTimeoutAlarm == null ? "---" : String.valueOf(queueTimeoutAlarm.getCount());
            queueTimeoutCount = leftCount + " / " + ((DtpExecutor)executor).getQueueTimeoutCount();
        } else {
            queueTimeoutCount = "--- / ---";
        }
        return new ImmutableTriple((Object)rejectCount, (Object)runTimeoutCount, (Object)queueTimeoutCount);
    }

    private static String buildKey(String threadPoolName, String notifyType) {
        return threadPoolName + ":" + notifyType;
    }
}

