/*
 * Decompiled with CFR 0.152.
 */
package com.dtp.core.notify.lark;

import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpResponse;
import com.dtp.common.dto.NotifyPlatform;
import com.dtp.core.notify.AbstractNotifier;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractLarkNotifier
extends AbstractNotifier {
    private static final Logger log = LoggerFactory.getLogger(AbstractLarkNotifier.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doSend(NotifyPlatform notifyPlatform, String text) {
        String serverUrl = "https://open.feishu.cn/open-apis/bot/v2/hook/" + notifyPlatform.getUrlKey();
        HttpResponse response = null;
        try {
            response = HttpRequest.post((String)serverUrl).body(text).execute();
        }
        catch (Exception e) {
            log.error("DynamicTp notify, lark send fail...", (Throwable)e);
        }
        finally {
            if (Objects.nonNull(response)) {
                log.info("DynamicTp notify, lark send success, response: {}, request:{}", (Object)response.body(), (Object)text);
            }
        }
    }
}

