/*
 * Decompiled with CFR 0.152.
 */
package com.dtp.core.parser;

import cn.hutool.core.map.MapUtil;
import com.dtp.common.em.ConfigFileTypeEnum;
import com.dtp.common.util.StringUtil;
import com.dtp.core.parser.AbstractConfigParser;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonConfigParser
extends AbstractConfigParser {
    private static final Logger log = LoggerFactory.getLogger(JsonConfigParser.class);
    private static final List<ConfigFileTypeEnum> CONFIG_TYPE = Lists.newArrayList((Object[])new ConfigFileTypeEnum[]{ConfigFileTypeEnum.JSON});
    private static final ObjectMapper MAPPER = new ObjectMapper();

    @Override
    public List<ConfigFileTypeEnum> type() {
        return CONFIG_TYPE;
    }

    @Override
    public Map<Object, Object> doParse(String content) throws IOException {
        return this.doParse(content, "spring.dynamic.tp");
    }

    @Override
    public Map<Object, Object> doParse(String content, String prefix) throws IOException {
        Map originMap = (Map)MAPPER.readValue(content, LinkedHashMap.class);
        HashMap result = Maps.newHashMap();
        this.flatMap(result, originMap, prefix);
        return result;
    }

    private void flatMap(Map<Object, Object> result, Map<String, Object> dataMap, String prefix) {
        if (MapUtil.isEmpty(dataMap)) {
            return;
        }
        dataMap.forEach((k, v) -> {
            String fullKey = this.genFullKey(prefix, (String)k);
            if (v instanceof Map) {
                this.flatMap(result, (Map)v, fullKey);
                return;
            }
            if (v instanceof Collection) {
                int count = 0;
                for (Object obj : (Collection)v) {
                    String kk = "[" + count++ + "]";
                    this.flatMap(result, Collections.singletonMap(kk, obj), fullKey);
                }
                return;
            }
            result.put(fullKey, v);
        });
    }

    private String genFullKey(String prefix, String key) {
        if (StringUtil.isEmpty((CharSequence)prefix)) {
            return key;
        }
        return key.startsWith("[") ? prefix.concat(key) : prefix.concat(".").concat(key);
    }
}

