/*
 * Decompiled with CFR 0.152.
 */
package com.dtp.core.refresh;

import cn.hutool.core.map.MapUtil;
import com.dtp.common.config.DtpProperties;
import com.dtp.common.em.ConfigFileTypeEnum;
import com.dtp.common.event.RefreshEvent;
import com.dtp.core.DtpRegistry;
import com.dtp.core.handler.ConfigHandler;
import com.dtp.core.refresh.Refresher;
import com.dtp.core.support.PropertiesBinder;
import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.event.ApplicationEventMulticaster;

public abstract class AbstractRefresher
implements Refresher {
    private static final Logger log = LoggerFactory.getLogger(AbstractRefresher.class);
    @Resource
    private DtpProperties dtpProperties;
    @Resource
    private ApplicationEventMulticaster applicationEventMulticaster;

    @Override
    public void refresh(String content, ConfigFileTypeEnum fileTypeEnum) {
        if (StringUtils.isBlank((CharSequence)content) || Objects.isNull(fileTypeEnum)) {
            log.warn("DynamicTp refresh, empty content or null fileType.");
            return;
        }
        try {
            ConfigHandler configHandler = ConfigHandler.getInstance();
            Map<Object, Object> properties = configHandler.parseConfig(content, fileTypeEnum);
            this.doRefresh(properties);
        }
        catch (IOException e) {
            log.error("DynamicTp refresh error, content: {}, fileType: {}", new Object[]{content, fileTypeEnum, e});
        }
    }

    protected void doRefresh(Map<Object, Object> properties) {
        if (MapUtil.isEmpty(properties)) {
            log.warn("DynamicTp refresh, empty properties.");
            return;
        }
        PropertiesBinder.bindDtpProperties(properties, this.dtpProperties);
        this.doRefresh(this.dtpProperties);
    }

    protected void doRefresh(DtpProperties dtpProperties) {
        DtpRegistry.refresh(dtpProperties);
        this.publishEvent(dtpProperties);
    }

    private void publishEvent(DtpProperties dtpProperties) {
        RefreshEvent event = new RefreshEvent((Object)this, dtpProperties);
        this.applicationEventMulticaster.multicastEvent((ApplicationEvent)event);
    }
}

