/*
 * Decompiled with CFR 0.152.
 */
package com.dtp.core.spring;

import cn.hutool.core.collection.CollUtil;
import com.dtp.common.config.DtpProperties;
import com.dtp.common.config.ThreadPoolProperties;
import com.dtp.common.dto.NotifyItem;
import com.dtp.common.em.QueueTypeEnum;
import com.dtp.common.util.BeanUtil;
import com.dtp.core.reject.RejectHandlerGetter;
import com.dtp.core.support.ExecutorType;
import com.dtp.core.support.PropertiesBinder;
import com.dtp.core.support.TaskQueue;
import com.dtp.core.support.wrapper.TaskWrapper;
import com.dtp.core.support.wrapper.TaskWrappers;
import com.dtp.core.thread.EagerDtpExecutor;
import com.dtp.core.thread.NamedThreadFactory;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.env.Environment;
import org.springframework.core.type.AnnotationMetadata;

public class DtpBeanDefinitionRegistrar
implements ImportBeanDefinitionRegistrar,
EnvironmentAware {
    private static final Logger log = LoggerFactory.getLogger(DtpBeanDefinitionRegistrar.class);
    private Environment environment;

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    public void registerBeanDefinitions(AnnotationMetadata importingClassMetadata, BeanDefinitionRegistry registry) {
        DtpProperties dtpProperties = new DtpProperties();
        PropertiesBinder.bindDtpProperties(this.environment, dtpProperties);
        List executors = dtpProperties.getExecutors();
        if (CollUtil.isEmpty((Collection)executors)) {
            log.warn("DynamicTp registrar, no executors are configured.");
            return;
        }
        executors.forEach(x -> {
            Class<?> executorTypeClass = ExecutorType.getClass(x.getExecutorType());
            String beanName = x.getThreadPoolName();
            Map<String, Object> properties = this.buildProperties((ThreadPoolProperties)x);
            Object[] args = this.buildArgs(executorTypeClass, (ThreadPoolProperties)x);
            BeanUtil.registerIfAbsent((BeanDefinitionRegistry)registry, (String)beanName, executorTypeClass, properties, (Object[])args);
        });
    }

    private Map<String, Object> buildProperties(ThreadPoolProperties tpp) {
        HashMap properties = Maps.newHashMap();
        properties.put("threadPoolName", tpp.getThreadPoolName());
        properties.put("theadPoolAliasName", tpp.getTheadPoolAliasName());
        properties.put("allowCoreThreadTimeOut", tpp.isAllowCoreThreadTimeOut());
        properties.put("waitForTasksToCompleteOnShutdown", tpp.isWaitForTasksToCompleteOnShutdown());
        properties.put("awaitTerminationSeconds", tpp.getAwaitTerminationSeconds());
        properties.put("preStartAllCoreThreads", tpp.isPreStartAllCoreThreads());
        properties.put("runTimeout", tpp.getRunTimeout());
        properties.put("queueTimeout", tpp.getQueueTimeout());
        List notifyItems = NotifyItem.mergeAllNotifyItems((List)tpp.getNotifyItems());
        properties.put("notifyItems", notifyItems);
        List<TaskWrapper> taskWrappers = TaskWrappers.getInstance().getByNames(tpp.getTaskWrapperNames());
        properties.put("taskWrappers", taskWrappers);
        return properties;
    }

    private Object[] buildArgs(Class<?> clazz, ThreadPoolProperties tpp) {
        Object taskQueue = clazz.equals(EagerDtpExecutor.class) ? new TaskQueue(tpp.getQueueCapacity()) : QueueTypeEnum.buildBlockingQueue((String)tpp.getQueueType(), (int)tpp.getQueueCapacity(), (boolean)tpp.isFair());
        return new Object[]{tpp.getCorePoolSize(), tpp.getMaximumPoolSize(), tpp.getKeepAliveTime(), tpp.getUnit(), taskQueue, new NamedThreadFactory(tpp.getThreadNamePrefix()), RejectHandlerGetter.buildRejectedHandler(tpp.getRejectedHandlerType())};
    }
}

