/*
 * Decompiled with CFR 0.152.
 */
package com.dtp.core.spring;

import com.dtp.common.ApplicationContextHolder;
import com.dtp.common.dto.ExecutorWrapper;
import com.dtp.core.DtpRegistry;
import com.dtp.core.support.DynamicTp;
import com.dtp.core.support.TaskQueue;
import com.dtp.core.thread.DtpExecutor;
import com.dtp.core.thread.EagerDtpExecutor;
import java.util.concurrent.Executor;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.context.ApplicationContext;

public class DtpPostProcessor
implements BeanPostProcessor {
    private static final Logger log = LoggerFactory.getLogger(DtpPostProcessor.class);

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        DynamicTp dynamicTp;
        if (!(bean instanceof ThreadPoolExecutor)) {
            return bean;
        }
        if (bean instanceof DtpExecutor) {
            DtpExecutor dtpExecutor = (DtpExecutor)bean;
            if (bean instanceof EagerDtpExecutor) {
                ((TaskQueue)((Object)dtpExecutor.getQueue())).setExecutor((EagerDtpExecutor)dtpExecutor);
            }
            this.registerDtp(dtpExecutor);
            return dtpExecutor;
        }
        ApplicationContext applicationContext = ApplicationContextHolder.getInstance();
        try {
            dynamicTp = (DynamicTp)applicationContext.findAnnotationOnBean(beanName, DynamicTp.class);
            if (dynamicTp == null) {
                return bean;
            }
        }
        catch (NoSuchBeanDefinitionException e) {
            log.error("There is no bean with the given name {}", (Object)beanName, (Object)e);
            return bean;
        }
        String poolName = StringUtils.isNotBlank((CharSequence)dynamicTp.value()) ? dynamicTp.value() : beanName;
        this.registerCommon(poolName, (ThreadPoolExecutor)bean);
        return bean;
    }

    private void registerDtp(DtpExecutor executor) {
        DtpRegistry.registerDtp(executor, "beanPostProcessor");
    }

    private void registerCommon(String poolName, ThreadPoolExecutor executor) {
        ExecutorWrapper wrapper = new ExecutorWrapper(poolName, (Executor)executor);
        DtpRegistry.registerCommon(wrapper, "beanPostProcessor");
    }
}

