/*
 * Decompiled with CFR 0.152.
 */
package com.dtp.logging;

import com.dtp.logging.AbstractDtpLogging;
import com.dtp.logging.log4j2.DtpLog4j2Logging;
import com.dtp.logging.logback.DtpLogbackLogging;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DtpLoggingInitializer {
    private static final Logger log = LoggerFactory.getLogger(DtpLoggingInitializer.class);
    private static AbstractDtpLogging dtpLogging;
    private final AtomicBoolean init = new AtomicBoolean(false);

    public static DtpLoggingInitializer getInstance() {
        return LoggingInstance.INSTANCE;
    }

    public void loadConfiguration() {
        if (Objects.isNull(dtpLogging)) {
            return;
        }
        if (this.init.compareAndSet(false, true)) {
            dtpLogging.loadConfiguration();
            dtpLogging.initMonitorLogger();
        }
    }

    static {
        try {
            Class.forName("ch.qos.logback.classic.Logger");
            dtpLogging = new DtpLogbackLogging();
        }
        catch (ClassNotFoundException e) {
            try {
                Class.forName("org.apache.logging.log4j.LogManager");
                dtpLogging = new DtpLog4j2Logging();
            }
            catch (ClassNotFoundException classNotFoundException) {
                log.error("DynamicTp initialize logging failed, please check whether logback or log4j related dependencies exist.");
            }
        }
    }

    private static class LoggingInstance {
        private static final DtpLoggingInitializer INSTANCE = new DtpLoggingInitializer();

        private LoggingInstance() {
        }
    }
}

