/*
 * Decompiled with CFR 0.152.
 */
package com.excel.poi;

import com.excel.poi.entity.ExcelEntity;
import com.excel.poi.excel.ExcelReader;
import com.excel.poi.excel.ExcelWriter;
import com.excel.poi.exception.ExcelBootException;
import com.excel.poi.factory.ExcelMappingFactory;
import com.excel.poi.function.ExportFunction;
import com.excel.poi.function.ImportFunction;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLEncoder;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExcelBoot {
    private static final Logger log = LoggerFactory.getLogger(ExcelBoot.class);
    private HttpServletResponse httpServletResponse;
    private OutputStream outputStream;
    private InputStream inputStream;
    private String fileName;
    private Class excelClass;
    private Integer pageSize;
    private Integer rowAccessWindowSize;
    private Integer recordCountPerSheet;
    private Boolean openAutoColumWidth;

    protected ExcelBoot(InputStream inputStream, Class excelClass) {
        this(null, null, inputStream, null, excelClass, null, null, null, null);
    }

    protected ExcelBoot(OutputStream outputStream, String fileName, Class excelClass) {
        this(null, outputStream, null, fileName, excelClass, 3000, 2000, 80000, true);
    }

    protected ExcelBoot(HttpServletResponse response, String fileName, Class excelClass) {
        this(response, null, null, fileName, excelClass, 3000, 2000, 80000, true);
    }

    protected ExcelBoot(HttpServletResponse response, OutputStream outputStream, InputStream inputStream, String fileName, Class excelClass, Integer pageSize, Integer rowAccessWindowSize, Integer recordCountPerSheet, Boolean openAutoColumWidth) {
        this.httpServletResponse = response;
        this.outputStream = outputStream;
        this.inputStream = inputStream;
        this.fileName = fileName;
        this.excelClass = excelClass;
        this.pageSize = pageSize;
        this.rowAccessWindowSize = rowAccessWindowSize;
        this.recordCountPerSheet = recordCountPerSheet;
        this.openAutoColumWidth = openAutoColumWidth;
    }

    public static ExcelBoot ExportBuilder(HttpServletResponse httpServletResponse, String fileName, Class clazz) {
        return new ExcelBoot(httpServletResponse, fileName, clazz);
    }

    public static ExcelBoot ExportBuilder(OutputStream outputStream, String fileName, Class clazz) {
        return new ExcelBoot(outputStream, fileName, clazz);
    }

    public static ExcelBoot ExportBuilder(HttpServletResponse response, String fileName, Class excelClass, Integer pageSize, Integer rowAccessWindowSize, Integer recordCountPerSheet, Boolean openAutoColumWidth) {
        return new ExcelBoot(response, null, null, fileName, excelClass, pageSize, rowAccessWindowSize, recordCountPerSheet, openAutoColumWidth);
    }

    public static ExcelBoot ExportBuilder(OutputStream outputStream, String fileName, Class excelClass, Integer pageSize, Integer rowAccessWindowSize, Integer recordCountPerSheet, Boolean openAutoColumWidth) {
        return new ExcelBoot(null, outputStream, null, fileName, excelClass, pageSize, rowAccessWindowSize, recordCountPerSheet, openAutoColumWidth);
    }

    public static ExcelBoot ImportBuilder(InputStream inputStreamm, Class clazz) {
        return new ExcelBoot(inputStreamm, clazz);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <R, T> void exportResponse(R param, ExportFunction<R, T> exportFunction) {
        SXSSFWorkbook sxssfWorkbook = null;
        try {
            try {
                this.verifyResponse();
                sxssfWorkbook = this.commonSingleSheet(param, exportFunction);
                this.download(sxssfWorkbook, this.httpServletResponse, URLEncoder.encode(this.fileName + ".xlsx", "UTF-8"));
            }
            finally {
                if (sxssfWorkbook != null) {
                    sxssfWorkbook.close();
                }
                if (this.httpServletResponse != null && this.httpServletResponse.getOutputStream() != null) {
                    this.httpServletResponse.getOutputStream().close();
                }
            }
        }
        catch (Exception e) {
            throw new ExcelBootException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <R, T> void exportStream(R param, ExportFunction<R, T> exportFunction) {
        OutputStream outputStream = null;
        try {
            try {
                outputStream = this.generateStream(param, exportFunction);
                this.write(outputStream);
            }
            finally {
                if (outputStream != null) {
                    outputStream.close();
                }
            }
        }
        catch (Exception e) {
            throw new ExcelBootException(e);
        }
    }

    public <R, T> OutputStream generateStream(R param, ExportFunction<R, T> exportFunction) throws IOException {
        SXSSFWorkbook sxssfWorkbook = null;
        try {
            this.verifyStream();
            sxssfWorkbook = this.commonSingleSheet(param, exportFunction);
            sxssfWorkbook.write(this.outputStream);
            return this.outputStream;
        }
        catch (Exception e) {
            log.error("\u751f\u6210Excel\u53d1\u751f\u5f02\u5e38! \u5f02\u5e38\u4fe1\u606f:", (Throwable)e);
            if (sxssfWorkbook != null) {
                sxssfWorkbook.close();
            }
            throw new ExcelBootException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <R, T> void exportMultiSheetResponse(R param, ExportFunction<R, T> exportFunction) {
        SXSSFWorkbook sxssfWorkbook = null;
        try {
            try {
                this.verifyResponse();
                sxssfWorkbook = this.commonMultiSheet(param, exportFunction);
                this.download(sxssfWorkbook, this.httpServletResponse, URLEncoder.encode(this.fileName + ".xlsx", "UTF-8"));
            }
            finally {
                if (sxssfWorkbook != null) {
                    sxssfWorkbook.close();
                }
            }
        }
        catch (Exception e) {
            throw new ExcelBootException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <R, T> void exportMultiSheetStream(R param, ExportFunction<R, T> exportFunction) {
        OutputStream outputStream = null;
        try {
            try {
                outputStream = this.generateMultiSheetStream(param, exportFunction);
                this.write(outputStream);
            }
            finally {
                if (outputStream != null) {
                    outputStream.close();
                }
            }
        }
        catch (Exception e) {
            throw new ExcelBootException(e);
        }
    }

    public <R, T> OutputStream generateMultiSheetStream(R param, ExportFunction<R, T> exportFunction) throws IOException {
        SXSSFWorkbook sxssfWorkbook = null;
        try {
            this.verifyStream();
            sxssfWorkbook = this.commonMultiSheet(param, exportFunction);
            sxssfWorkbook.write(this.outputStream);
            return this.outputStream;
        }
        catch (Exception e) {
            log.error("\u5206Sheet\u751f\u6210Excel\u53d1\u751f\u5f02\u5e38! \u5f02\u5e38\u4fe1\u606f:", (Throwable)e);
            if (sxssfWorkbook != null) {
                sxssfWorkbook.close();
            }
            throw new ExcelBootException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportTemplate() {
        SXSSFWorkbook sxssfWorkbook = null;
        try {
            try {
                this.verifyResponse();
                this.verifyParams();
                ExcelEntity excelMapping = ExcelMappingFactory.loadExportExcelClass(this.excelClass, this.fileName);
                ExcelWriter excelWriter = new ExcelWriter(excelMapping, this.pageSize, this.rowAccessWindowSize, this.recordCountPerSheet, this.openAutoColumWidth);
                sxssfWorkbook = excelWriter.generateTemplateWorkbook();
                this.download(sxssfWorkbook, this.httpServletResponse, URLEncoder.encode(this.fileName + ".xlsx", "UTF-8"));
            }
            finally {
                if (sxssfWorkbook != null) {
                    sxssfWorkbook.close();
                }
                if (this.httpServletResponse != null && this.httpServletResponse.getOutputStream() != null) {
                    this.httpServletResponse.getOutputStream().close();
                }
            }
        }
        catch (Exception e) {
            throw new ExcelBootException(e);
        }
    }

    public void importExcel(ImportFunction importFunction) {
        try {
            if (importFunction == null) {
                throw new ExcelBootException("excelReadHandler\u53c2\u6570\u4e3a\u7a7a!");
            }
            if (this.inputStream == null) {
                throw new ExcelBootException("inputStream\u53c2\u6570\u4e3a\u7a7a!");
            }
            ExcelEntity excelMapping = ExcelMappingFactory.loadImportExcelClass(this.excelClass);
            ExcelReader excelReader = new ExcelReader(this.excelClass, excelMapping, importFunction);
            excelReader.process(this.inputStream);
        }
        catch (Exception e) {
            throw new ExcelBootException(e);
        }
    }

    private <R, T> SXSSFWorkbook commonSingleSheet(R param, ExportFunction<R, T> exportFunction) throws Exception {
        this.verifyParams();
        ExcelEntity excelMapping = ExcelMappingFactory.loadExportExcelClass(this.excelClass, this.fileName);
        ExcelWriter excelWriter = new ExcelWriter(excelMapping, this.pageSize, this.rowAccessWindowSize, this.recordCountPerSheet, this.openAutoColumWidth);
        return excelWriter.generateWorkbook(param, exportFunction);
    }

    private <R, T> SXSSFWorkbook commonMultiSheet(R param, ExportFunction<R, T> exportFunction) throws Exception {
        this.verifyParams();
        ExcelEntity excelMapping = ExcelMappingFactory.loadExportExcelClass(this.excelClass, this.fileName);
        ExcelWriter excelWriter = new ExcelWriter(excelMapping, this.pageSize, this.rowAccessWindowSize, this.recordCountPerSheet, this.openAutoColumWidth);
        return excelWriter.generateMultiSheetWorkbook(param, exportFunction);
    }

    private void write(OutputStream out) throws IOException {
        if (null != out) {
            out.flush();
        }
    }

    private void download(SXSSFWorkbook wb, HttpServletResponse response, String filename) throws IOException {
        ServletOutputStream out = response.getOutputStream();
        response.setContentType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
        response.setHeader("Content-disposition", String.format("attachment; filename=%s", filename));
        if (null != out) {
            wb.write((OutputStream)out);
            out.flush();
        }
    }

    private void verifyResponse() {
        if (this.httpServletResponse == null) {
            throw new ExcelBootException("httpServletResponse\u53c2\u6570\u4e3a\u7a7a!");
        }
    }

    private void verifyStream() {
        if (this.outputStream == null) {
            throw new ExcelBootException("outputStream\u53c2\u6570\u4e3a\u7a7a!");
        }
    }

    private void verifyParams() {
        if (this.excelClass == null) {
            throw new ExcelBootException("excelClass\u53c2\u6570\u4e3a\u7a7a!");
        }
        if (this.fileName == null) {
            throw new ExcelBootException("fileName\u53c2\u6570\u4e3a\u7a7a!");
        }
    }
}

