/*
 * Decompiled with CFR 0.152.
 */
package com.excel.poi.excel;

import com.excel.poi.common.DateFormatUtil;
import com.excel.poi.common.StringUtil;
import com.excel.poi.entity.ExcelEntity;
import com.excel.poi.entity.ExcelPropertyEntity;
import com.excel.poi.function.ExportFunction;
import java.awt.Color;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.xssf.streaming.SXSSFCell;
import org.apache.poi.xssf.streaming.SXSSFRow;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFColor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExcelWriter {
    private static final Logger log = LoggerFactory.getLogger(ExcelWriter.class);
    private Integer rowAccessWindowSize;
    private ExcelEntity excelEntity;
    private Integer pageSize;
    private Integer nullCellCount = 0;
    private Integer recordCountPerSheet;
    private XSSFCellStyle headCellStyle;
    private Map<Integer, Integer> columnWidthMap = new HashMap<Integer, Integer>();
    private Boolean openAutoColumWidth;

    public ExcelWriter(ExcelEntity excelEntity, Integer pageSize, Integer rowAccessWindowSize, Integer recordCountPerSheet, Boolean openAutoColumWidth) {
        this.excelEntity = excelEntity;
        this.pageSize = pageSize;
        this.rowAccessWindowSize = rowAccessWindowSize;
        this.recordCountPerSheet = recordCountPerSheet;
        this.openAutoColumWidth = openAutoColumWidth;
    }

    public <P, T> SXSSFWorkbook generateWorkbook(P param, ExportFunction<P, T> exportFunction) throws Exception {
        SXSSFWorkbook workbook = new SXSSFWorkbook(this.rowAccessWindowSize.intValue());
        int sheetNo = 1;
        int rowNum = 1;
        List<ExcelPropertyEntity> propertyList = this.excelEntity.getPropertyList();
        SXSSFSheet sheet = this.generateHeader(workbook, propertyList, this.excelEntity.getFileName());
        int firstPageNo = 1;
        while (true) {
            List<T> data;
            if ((data = exportFunction.pageQuery(param, firstPageNo, this.pageSize)) == null || data.isEmpty()) {
                if (rowNum != 1) {
                    this.sizeColumWidth(sheet, propertyList.size());
                }
                log.warn("\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a,\u7ed3\u675f\u67e5\u8be2!");
                break;
            }
            int dataSize = data.size();
            int i = 1;
            while (i <= dataSize) {
                T queryResult = data.get(i - 1);
                Object convertResult = exportFunction.convert(queryResult);
                if (rowNum > 1000000) {
                    this.sizeColumWidth(sheet, propertyList.size());
                    sheet = this.generateHeader(workbook, propertyList, this.excelEntity.getFileName() + "_" + sheetNo);
                    ++sheetNo;
                    rowNum = 1;
                    this.columnWidthMap.clear();
                }
                SXSSFRow row = sheet.createRow(rowNum);
                for (int j = 0; j < propertyList.size(); ++j) {
                    SXSSFCell cell = row.createCell(j);
                    this.buildCellValue(cell, convertResult, propertyList.get(j));
                    this.calculateColumWidth(cell, j);
                }
                if (this.nullCellCount.intValue() == propertyList.size()) {
                    log.warn("\u5ffd\u7565\u4e00\u884c\u7a7a\u6570\u636e!");
                    sheet.removeRow((Row)row);
                    --rowNum;
                }
                this.nullCellCount = 0;
                ++i;
                ++rowNum;
            }
            if (data.size() < this.pageSize) {
                this.sizeColumWidth(sheet, propertyList.size());
                log.warn("\u67e5\u8be2\u7ed3\u679c\u6570\u91cf\u5c0f\u4e8epageSize,\u7ed3\u675f\u67e5\u8be2!");
                break;
            }
            ++firstPageNo;
        }
        return workbook;
    }

    public SXSSFWorkbook generateTemplateWorkbook() {
        SXSSFWorkbook workbook = new SXSSFWorkbook(this.rowAccessWindowSize.intValue());
        List<ExcelPropertyEntity> propertyList = this.excelEntity.getPropertyList();
        SXSSFSheet sheet = this.generateHeader(workbook, propertyList, this.excelEntity.getFileName());
        SXSSFRow row = sheet.createRow(1);
        for (int j = 0; j < propertyList.size(); ++j) {
            SXSSFCell cell = row.createCell(j);
            cell.setCellValue(propertyList.get(j).getTemplateCellValue());
            this.calculateColumWidth(cell, j);
        }
        this.sizeColumWidth(sheet, propertyList.size());
        return workbook;
    }

    public <R, T> SXSSFWorkbook generateMultiSheetWorkbook(R param, ExportFunction<R, T> exportFunction) throws Exception {
        int pageNo = 1;
        int sheetNo = 1;
        int rowNum = 1;
        SXSSFWorkbook workbook = new SXSSFWorkbook(this.rowAccessWindowSize.intValue());
        List<ExcelPropertyEntity> propertyList = this.excelEntity.getPropertyList();
        SXSSFSheet sheet = this.generateHeader(workbook, propertyList, this.excelEntity.getFileName());
        while (true) {
            List<T> data;
            if ((data = exportFunction.pageQuery(param, pageNo, this.pageSize)) == null || data.isEmpty()) {
                if (rowNum != 1) {
                    this.sizeColumWidth(sheet, propertyList.size());
                }
                log.warn("\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a,\u7ed3\u675f\u67e5\u8be2!");
                break;
            }
            int i = 1;
            while (i <= data.size()) {
                T queryResult = data.get(i - 1);
                Object convertResult = exportFunction.convert(queryResult);
                if (rowNum > this.recordCountPerSheet) {
                    this.sizeColumWidth(sheet, propertyList.size());
                    sheet = this.generateHeader(workbook, propertyList, this.excelEntity.getFileName() + "_" + sheetNo);
                    ++sheetNo;
                    rowNum = 1;
                    this.columnWidthMap.clear();
                }
                SXSSFRow bodyRow = sheet.createRow(rowNum);
                for (int j = 0; j < propertyList.size(); ++j) {
                    SXSSFCell cell = bodyRow.createCell(j);
                    this.buildCellValue(cell, convertResult, propertyList.get(j));
                    this.calculateColumWidth(cell, j);
                }
                if (this.nullCellCount.intValue() == propertyList.size()) {
                    log.warn("\u5ffd\u7565\u4e00\u884c\u7a7a\u6570\u636e!");
                    sheet.removeRow((Row)bodyRow);
                    --rowNum;
                }
                this.nullCellCount = 0;
                ++i;
                ++rowNum;
            }
            if (data.size() < this.pageSize) {
                this.sizeColumWidth(sheet, propertyList.size());
                log.warn("\u67e5\u8be2\u7ed3\u679c\u6570\u91cf\u5c0f\u4e8epageSize,\u7ed3\u675f\u67e5\u8be2!");
                break;
            }
            ++pageNo;
        }
        return workbook;
    }

    private void sizeColumWidth(SXSSFSheet sheet, Integer columnSize) {
        if (this.openAutoColumWidth.booleanValue()) {
            for (int j = 0; j < columnSize; ++j) {
                if (this.columnWidthMap.get(j) == null) continue;
                sheet.setColumnWidth(j, this.columnWidthMap.get(j) * 256);
            }
        }
    }

    private void calculateColumWidth(SXSSFCell cell, Integer columnIndex) {
        if (this.openAutoColumWidth.booleanValue()) {
            String cellValue = cell.getStringCellValue();
            int length = cellValue.getBytes().length;
            length += (int)Math.ceil((double)((cellValue.length() * 3 - length) / 2) * 0.1);
            length = Math.max(length, 15);
            length = Math.min(length, 60);
            if (this.columnWidthMap.get(columnIndex) == null || this.columnWidthMap.get(columnIndex) < length) {
                this.columnWidthMap.put(columnIndex, length);
            }
        }
    }

    private SXSSFSheet generateHeader(SXSSFWorkbook workbook, List<ExcelPropertyEntity> propertyList, String sheetName) {
        SXSSFSheet sheet = workbook.createSheet(sheetName);
        SXSSFRow headerRow = sheet.createRow(0);
        headerRow.setHeight((short)600);
        CellStyle headCellStyle = this.getHeaderCellStyle(workbook);
        for (int i = 0; i < propertyList.size(); ++i) {
            SXSSFCell cell = headerRow.createCell(i);
            cell.setCellStyle(headCellStyle);
            cell.setCellValue(propertyList.get(i).getColumnName());
            this.calculateColumWidth(cell, i);
        }
        return sheet;
    }

    private void buildCellValue(SXSSFCell cell, Object entity, ExcelPropertyEntity property) throws Exception {
        Field field = property.getFieldEntity();
        Object cellValue = field.get(entity);
        if (StringUtil.isBlank(cellValue) || "0".equals(cellValue.toString()) || "0.0".equals(cellValue.toString()) || "0.00".equals(cellValue.toString())) {
            Integer n = this.nullCellCount;
            Integer n2 = this.nullCellCount = Integer.valueOf(this.nullCellCount + 1);
        }
        if (cellValue == null) {
            cell.setCellValue("");
        } else if (cellValue instanceof BigDecimal) {
            if (-1 == property.getScale()) {
                cell.setCellValue(cellValue.toString());
            } else {
                cell.setCellValue(((BigDecimal)cellValue).setScale((int)property.getScale(), property.getRoundingMode()).toString());
            }
        } else if (cellValue instanceof Date) {
            cell.setCellValue(DateFormatUtil.format(property.getDateFormat(), (Date)cellValue));
        } else {
            cell.setCellValue(cellValue.toString());
        }
    }

    public CellStyle getHeaderCellStyle(SXSSFWorkbook workbook) {
        if (this.headCellStyle == null) {
            this.headCellStyle = workbook.getXSSFWorkbook().createCellStyle();
            this.headCellStyle.setBorderTop(BorderStyle.NONE);
            this.headCellStyle.setBorderRight(BorderStyle.NONE);
            this.headCellStyle.setBorderBottom(BorderStyle.NONE);
            this.headCellStyle.setBorderLeft(BorderStyle.NONE);
            this.headCellStyle.setAlignment(HorizontalAlignment.CENTER);
            this.headCellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
            XSSFColor color = new XSSFColor(new Color(217, 217, 217));
            this.headCellStyle.setFillForegroundColor(color);
            this.headCellStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
            Font font = workbook.createFont();
            font.setFontName("\u5fae\u8f6f\u96c5\u9ed1");
            font.setColor(IndexedColors.ROYAL_BLUE.index);
            font.setBold(true);
            this.headCellStyle.setFont(font);
            this.headCellStyle.setDataFormat(workbook.createDataFormat().getFormat("@"));
        }
        return this.headCellStyle;
    }
}

