/*
 * Decompiled with CFR 0.152.
 */
package io.github.majusko.pulsar.collector;

import io.github.majusko.pulsar.annotation.PulsarConsumer;
import io.github.majusko.pulsar.collector.ConsumerHolder;
import io.github.majusko.pulsar.utils.SchemaUtils;
import io.github.majusko.pulsar.utils.UrlBuildService;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.context.annotation.Configuration;

@Configuration
public class ConsumerCollector
implements BeanPostProcessor {
    private final UrlBuildService urlBuildService;
    private Map<String, ConsumerHolder> consumers = new ConcurrentHashMap<String, ConsumerHolder>();

    public ConsumerCollector(UrlBuildService urlBuildService) {
        this.urlBuildService = urlBuildService;
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) {
        Class<?> beanClass = bean.getClass();
        this.consumers.putAll(Arrays.stream(beanClass.getDeclaredMethods()).filter($ -> $.isAnnotationPresent(PulsarConsumer.class)).collect(Collectors.toMap(method -> this.urlBuildService.buildConsumerName(beanClass, (Method)method), method -> new ConsumerHolder(method.getAnnotation(PulsarConsumer.class), (Method)method, bean, SchemaUtils.getParameterType(method)))));
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) {
        return bean;
    }

    public Map<String, ConsumerHolder> getConsumers() {
        return this.consumers;
    }

    public Optional<ConsumerHolder> getConsumer(String methodDescriptor) {
        return Optional.ofNullable(this.consumers.get(methodDescriptor));
    }
}

