/*
 * Decompiled with CFR 0.152.
 */
package io.github.majusko.pulsar.utils;

import com.google.common.base.Strings;
import io.github.majusko.pulsar.properties.PulsarProperties;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class UrlBuildService {
    @Value(value="${pulsar.consumerNameDelimiter:}")
    private String consumerNameDelimiter;
    private static final String PERSISTENT_PREFIX = "persistent";
    private static final String NON_PERSISTENT_PREFIX = "non-persistent";
    private static final String DEFAULT_PERSISTENCE = "persistent";
    private static final String CONSUMER_NAME_PREFIX = "consumer";
    private static final String SUBSCRIPTION_NAME_PREFIX = "subscription";
    private final PulsarProperties pulsarProperties;

    private UrlBuildService(PulsarProperties pulsarProperties) {
        this.pulsarProperties = pulsarProperties;
    }

    public String buildTopicUrl(String topic) {
        return "persistent://" + this.pulsarProperties.getTenant() + "/" + this.pulsarProperties.getNamespace() + "/" + topic;
    }

    public String buildPulsarConsumerName(String customConsumerName, String consumerName) {
        if (Strings.isNullOrEmpty((String)customConsumerName)) {
            return CONSUMER_NAME_PREFIX + this.consumerNameDelimiter + consumerName;
        }
        return customConsumerName;
    }

    public String buildPulsarSubscriptionName(String customSubscriptionName, String consumerName) {
        if (Strings.isNullOrEmpty((String)customSubscriptionName)) {
            return SUBSCRIPTION_NAME_PREFIX + this.consumerNameDelimiter + consumerName;
        }
        return customSubscriptionName;
    }

    public String buildConsumerName(Class<?> clazz, Method method) {
        return clazz.getName() + this.consumerNameDelimiter + method.getName() + Arrays.stream(method.getGenericParameterTypes()).map(Type::getTypeName).collect(Collectors.joining(this.consumerNameDelimiter));
    }
}

