/*
 * Decompiled with CFR 0.152.
 */
package pl.mjaron.tinyloki;

public class Utils {
    public static void escapeJsonString(StringBuilder b, CharSequence text) {
        int length = text.length();
        block4: for (int i = 0; i < length; ++i) {
            char c = text.charAt(i);
            switch (c) {
                case '\"': {
                    b.append("\\\"");
                    continue block4;
                }
                case '\\': {
                    b.append("\\\\");
                    continue block4;
                }
                default: {
                    if (c > '\u001f') {
                        b.append(c);
                        continue block4;
                    }
                    b.append("\\u");
                    String hex = "000" + Integer.toHexString(c);
                    b.append(hex.substring(hex.length() - 4));
                }
            }
        }
    }

    public static void sleep(long milliseconds) {
        try {
            Thread.sleep(milliseconds);
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Thread.sleep() has failed.", e);
        }
    }

    public static boolean isAsciiCapitalLetter(char ch) {
        return ch >= 'A' && ch <= 'Z';
    }

    public static boolean isAsciiLowercaseLetter(char ch) {
        return ch >= 'a' && ch <= 'z';
    }

    public static boolean isAsciiLetter(char ch) {
        return Utils.isAsciiCapitalLetter(ch) || Utils.isAsciiLowercaseLetter(ch);
    }

    public static boolean isAsciiDigit(char ch) {
        return ch >= '0' && ch <= '9';
    }

    public static boolean isAsciiLetterOrDigit(char ch) {
        return Utils.isAsciiLetter(ch) || Utils.isAsciiDigit(ch);
    }
}

