/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.bpmn.converter.parser;

import java.util.List;
import javax.xml.stream.XMLStreamReader;
import org.activiti.bpmn.constants.BpmnXMLConstants;
import org.activiti.bpmn.converter.export.ProcessExport;
import org.activiti.bpmn.converter.util.BpmnXMLUtil;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.Process;
import org.apache.commons.lang3.StringUtils;

public class ProcessParser
implements BpmnXMLConstants {
    public Process parse(XMLStreamReader xtr, BpmnModel model) throws Exception {
        Process process = null;
        if (StringUtils.isNotEmpty((CharSequence)xtr.getAttributeValue(null, "id"))) {
            String candidateGroupsString;
            String candidateUsersString;
            String processId = xtr.getAttributeValue(null, "id");
            process = new Process();
            process.setId(processId);
            BpmnXMLUtil.addXMLLocation(process, xtr);
            process.setName(xtr.getAttributeValue(null, "name"));
            if (StringUtils.isNotEmpty((CharSequence)xtr.getAttributeValue(null, "isExecutable"))) {
                process.setExecutable(Boolean.parseBoolean(xtr.getAttributeValue(null, "isExecutable")));
            }
            if (StringUtils.isNotEmpty((CharSequence)(candidateUsersString = xtr.getAttributeValue("http://activiti.org/bpmn", "candidateStarterUsers")))) {
                List<String> candidateUsers = BpmnXMLUtil.parseDelimitedList(candidateUsersString);
                process.setCandidateStarterUsers(candidateUsers);
            }
            if (StringUtils.isNotEmpty((CharSequence)(candidateGroupsString = xtr.getAttributeValue("http://activiti.org/bpmn", "candidateStarterGroups")))) {
                List<String> candidateGroups = BpmnXMLUtil.parseDelimitedList(candidateGroupsString);
                process.setCandidateStarterGroups(candidateGroups);
            }
            BpmnXMLUtil.addCustomAttributes(xtr, process, ProcessExport.defaultProcessAttributes);
            model.getProcesses().add(process);
        }
        return process;
    }
}

