/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.bpmn.parser.handler;

import org.activiti.bpmn.model.BaseElement;
import org.activiti.bpmn.model.Transaction;
import org.activiti.engine.impl.bpmn.data.IOSpecification;
import org.activiti.engine.impl.bpmn.parser.BpmnParse;
import org.activiti.engine.impl.bpmn.parser.handler.AbstractActivityBpmnParseHandler;
import org.activiti.engine.impl.pvm.process.ActivityImpl;

public class TransactionParseHandler
extends AbstractActivityBpmnParseHandler<Transaction> {
    @Override
    public Class<? extends BaseElement> getHandledType() {
        return Transaction.class;
    }

    @Override
    protected void executeParse(BpmnParse bpmnParse, Transaction transaction) {
        ActivityImpl activity = this.createActivityOnCurrentScope(bpmnParse, transaction, "transaction");
        activity.setAsync(transaction.isAsynchronous());
        activity.setExclusive(!transaction.isNotExclusive());
        activity.setScope(true);
        activity.setActivityBehavior(bpmnParse.getActivityBehaviorFactory().createTransactionActivityBehavior(transaction));
        bpmnParse.setCurrentScope(activity);
        bpmnParse.processFlowElements(transaction.getFlowElements());
        this.processArtifacts(bpmnParse, transaction.getArtifacts(), activity);
        bpmnParse.removeCurrentScope();
        if (transaction.getIoSpecification() != null) {
            IOSpecification ioSpecification = this.createIOSpecification(bpmnParse, transaction.getIoSpecification());
            activity.setIoSpecification(ioSpecification);
        }
    }
}

