/*
 * Decompiled with CFR 0.152.
 */
package org.openoa.base.constant.enums;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.stream.Collectors;
import org.openoa.base.constant.enums.BpmnNodeParamTypeEnum;
import org.springframework.util.ObjectUtils;

public enum NodePropertyEnum {
    NODE_PROPERTY_LOOP(2, "\u5c42\u5c42\u5ba1\u6279", 1, BpmnNodeParamTypeEnum.BPMN_NODE_PARAM_SINGLE),
    NODE_PROPERTY_LEVEL(3, "\u6307\u5b9a\u5c42\u7ea7\u5ba1\u6279", 1, BpmnNodeParamTypeEnum.BPMN_NODE_PARAM_SINGLE),
    NODE_PROPERTY_ROLE(4, "\u6307\u5b9a\u89d2\u8272", 1, BpmnNodeParamTypeEnum.BPMN_NODE_PARAM_MULTIPLAYER),
    NODE_PROPERTY_PERSONNEL(5, "\u6307\u5b9a\u4eba\u5458", 1, BpmnNodeParamTypeEnum.BPMN_NODE_PARAM_MULTIPLAYER),
    NODE_PROPERTY_HRBP(6, "HRBP", 1, BpmnNodeParamTypeEnum.BPMN_NODE_PARAM_SINGLE),
    NODE_PROPERTY_CUSTOMIZE(7, "\u81ea\u9009\u6a21\u5757", 0, BpmnNodeParamTypeEnum.BPMN_NODE_PARAM_MULTIPLAYER),
    NODE_PROPERTY_BUSINESSTABLE(8, "\u5173\u8054\u4e1a\u52a1\u8868", 1, BpmnNodeParamTypeEnum.BPMN_NODE_PARAM_MULTIPLAYER),
    NODE_PROPERTY_OUT_SIDE_ACCESS(11, "\u5916\u90e8\u4f20\u5165\u4eba\u5458", 1, BpmnNodeParamTypeEnum.BPMN_NODE_PARAM_MULTIPLAYER),
    NODE_PROPERTY_START_USER(12, "\u53d1\u8d77\u4eba", 0, BpmnNodeParamTypeEnum.BPMN_NODE_PARAM_SINGLE),
    NODE_PROPERTY_DIRECT_LEADER(13, "\u76f4\u5c5e\u9886\u5bfc", 0, BpmnNodeParamTypeEnum.BPMN_NODE_PARAM_SINGLE);

    private Integer code;
    private String desc;
    private final BpmnNodeParamTypeEnum paramTypeEnum;
    private Integer hasPropertyTable;

    private NodePropertyEnum(Integer code, String desc, Integer hasPropertyTable, BpmnNodeParamTypeEnum paramTypeEnum) {
        this.code = code;
        this.desc = desc;
        this.paramTypeEnum = paramTypeEnum;
        this.hasPropertyTable = hasPropertyTable;
    }

    public static NodePropertyEnum getByCode(Integer code) {
        if (ObjectUtils.isEmpty((Object)code)) {
            return null;
        }
        for (NodePropertyEnum value : NodePropertyEnum.values()) {
            if (!code.equals(value.getCode())) continue;
            return value;
        }
        return null;
    }

    public static NodePropertyEnum getNodePropertyEnumByCode(Integer code) {
        List nodePropertyEnums = Lists.newArrayList((Object[])NodePropertyEnum.values()).stream().filter(o -> o.getHasPropertyTable().equals(1)).collect(Collectors.toList());
        for (NodePropertyEnum nodePropertyEnum : nodePropertyEnums) {
            if (!nodePropertyEnum.getCode().equals(code)) continue;
            return nodePropertyEnum;
        }
        return null;
    }

    public static String getDescByCode(Integer code) {
        for (NodePropertyEnum enums : NodePropertyEnum.values()) {
            if (!enums.code.equals(code)) continue;
            return enums.desc;
        }
        return null;
    }

    public Integer getCode() {
        return this.code;
    }

    public String getDesc() {
        return this.desc;
    }

    public BpmnNodeParamTypeEnum getParamTypeEnum() {
        return this.paramTypeEnum;
    }

    public Integer getHasPropertyTable() {
        return this.hasPropertyTable;
    }
}

