/*
 * Decompiled with CFR 0.152.
 */
package org.openoa.base.interf;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;

public interface AdaptorService {
    public static final ConcurrentHashMap<String, List<Enum<?>>> SUPPORTED_BUSINESS = new ConcurrentHashMap();

    public void setSupportBusinessObjects();

    default public void addSupportBusinessObjects(Enum<?> ... businessObjects) {
        this.addSupportBusinessObjects("", businessObjects);
    }

    default public void addSupportBusinessObjects(String marker, Enum<?> ... businessObjects) {
        String clsNameWithMaker = this.getClass().getName() + marker;
        if (businessObjects != null) {
            for (Enum<?> c : businessObjects) {
                if (SUPPORTED_BUSINESS.containsKey(clsNameWithMaker)) {
                    SUPPORTED_BUSINESS.get(this.getClass().getName() + marker).add(c);
                    continue;
                }
                SUPPORTED_BUSINESS.put(clsNameWithMaker, Lists.newArrayList((Object[])new Enum[]{c}));
            }
        }
    }

    default public boolean isSupportBusinessObject(Enum<?> businessObject) {
        return this.isSupportBusinessObject("", businessObject);
    }

    default public boolean isSupportBusinessObject(String marker, Enum<?> businessObject) {
        List<Enum<?>> enums;
        String clsNameWithMaker = this.getClass().getName() + marker;
        if (SUPPORTED_BUSINESS.containsKey(clsNameWithMaker)) {
            enums = SUPPORTED_BUSINESS.get(clsNameWithMaker);
            for (Enum<?> anEnum : enums) {
                if (anEnum != businessObject) continue;
                return true;
            }
        }
        this.setSupportBusinessObjects();
        if (SUPPORTED_BUSINESS.containsKey(clsNameWithMaker)) {
            enums = SUPPORTED_BUSINESS.get(clsNameWithMaker);
            for (Enum<?> anEnum : enums) {
                if (anEnum != businessObject) continue;
                return true;
            }
        }
        return false;
    }
}

