/*
 * Decompiled with CFR 0.152.
 */
package org.openoa.base.service;

import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import org.openoa.base.mapper.UserMapper;
import org.openoa.base.vo.BaseIdTranStruVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UserServiceImpl {
    @Autowired
    UserMapper userMapper;

    public List<BaseIdTranStruVo> queryByNameFuzzy(String userName) {
        List<BaseIdTranStruVo> users = this.userMapper.queryByNameFuzzy(userName);
        return users;
    }

    public List<BaseIdTranStruVo> queryCompanyByNameFuzzy(String companyName) {
        List<BaseIdTranStruVo> baseIdTranStruVos = this.userMapper.queryCompanyByNameFuzzy(companyName);
        return baseIdTranStruVos;
    }

    public List<BaseIdTranStruVo> queryUserByIds(Collection<String> userIds) {
        List<BaseIdTranStruVo> users = this.userMapper.queryByIds(userIds);
        return users;
    }

    public BaseIdTranStruVo getById(String id) {
        List<BaseIdTranStruVo> users = this.userMapper.queryByIds(Lists.newArrayList((Object[])new String[]{id}));
        if (CollectionUtils.isEmpty(users)) {
            return new BaseIdTranStruVo();
        }
        return users.get(0);
    }

    public List<BaseIdTranStruVo> queryLeadersByEmployeeIdAndTier(String employeeId, Integer tier) {
        List<BaseIdTranStruVo> users = this.userMapper.getLevelLeadersByEmployeeIdAndTier(employeeId, tier);
        return users;
    }

    public List<BaseIdTranStruVo> queryLeadersByEmployeeIdAndGrade(String employeeId, Integer grade) {
        List<BaseIdTranStruVo> users = this.userMapper.getLevelLeadersByEmployeeIdAndTier(employeeId, grade);
        return users;
    }

    public BaseIdTranStruVo queryLeaderByEmployeeIdAndLevel(String employeeId, Integer level) {
        return null;
    }

    public BaseIdTranStruVo queryEmployeeHrpbByEmployeeId(String employeeId) {
        BaseIdTranStruVo baseIdTranStruVo = this.userMapper.getHrpbByEmployeeId(employeeId);
        return baseIdTranStruVo;
    }

    public BaseIdTranStruVo queryEmployeeDirectLeaderById(String employeeId) {
        BaseIdTranStruVo baseIdTranStruVo = this.userMapper.getDirectLeaderByEmployeeId(employeeId);
        return baseIdTranStruVo;
    }
}

