/*
 * Decompiled with CFR 0.152.
 */
package org.openoa.base.service.empinfoprovider;

import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.openoa.base.service.UserServiceImpl;
import org.openoa.base.service.empinfoprovider.BpmnEmployeeInfoProviderService;
import org.openoa.base.vo.BaseIdTranStruVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class BpmnTestEmployeeInfoProvider
implements BpmnEmployeeInfoProviderService {
    @Autowired
    private UserServiceImpl userService;

    @Override
    public Map<String, String> provideEmployeeInfo(Collection<String> empIds) {
        List<BaseIdTranStruVo> users = this.userService.queryUserByIds(empIds);
        if (CollectionUtils.isEmpty(users)) {
            return Maps.newHashMap();
        }
        Map<String, String> empIdAndNameMap = users.stream().collect(Collectors.toMap(a -> a.getId(), BaseIdTranStruVo::getName, (k1, k2) -> k1));
        return empIdAndNameMap;
    }
}

