/*
 * Decompiled with CFR 0.152.
 */
package org.openoa.base.util;

import java.util.Calendar;
import java.util.Date;
import org.apache.commons.lang3.time.FastDateFormat;
import org.joda.time.DateTime;

public abstract class DateUtil {
    private static Date maxDate;
    private static Date minDate;
    private static final String YEAR_PATTERN = "yyyy";
    public static final FastDateFormat SDF_YEAR_PATTERN;
    private static final String MONTH_PATTERN = "yyyy-MM";
    public static final FastDateFormat SDF_MONTH_PATTERN;
    private static final String DATE_PATTERN = "yyyy-MM-dd";
    public static final FastDateFormat SDF_DATE_PATTERN;
    private static final String DATETIME_PATTERN_NO_SECOND = "yyyy-MM-dd HH:mm";
    public static final FastDateFormat SDF_DATETIME_PATTERN_NO_SECOND;
    private static final String DATETIME_PATTERN = "yyyy-MM-dd HH:mm:ss";
    public static final FastDateFormat SDF_DATETIME_PATTERN;
    private static final String DATETIME_PATTERN_WITH_DOT_FULL = "yyyy-MM-dd HH:mm:ss.SSS";
    public static final FastDateFormat SDF_DATETIME_PATTERN_WITH_DOT_FULL;
    private static final String DATETIME_T_PATTERN_NO_SECOND = "yyyy-MM-dd'T'HH:mm";
    public static final FastDateFormat SDF_T_DATETIME_PATTERN_NO_SECOND;
    private static final String DATETIME_T_PATTERN = "yyyy-MM-dd'T'HH:mm:ss";
    public static final FastDateFormat SDF_T_DATETIME_PATTERN;
    private static final String DATETIME_T_PATTERN_WITH_DOT_FULL = "yyyy-MM-dd'T'HH:mm:ss.SSS";
    public static final FastDateFormat SDF_T_DATETIME_PATTERN_WITH_DOT_FULL;
    private static final String DATETIME_PATTERN_WITH_COMPRESS = "yyyyMMddHHmmss";
    public static final FastDateFormat SDF_DATETIME_PATTERN_COMPRESS;
    private static final String DATETIME_PATTERN_DATE_WITH_COMPRESS = "yyyyMMdd";
    public static final FastDateFormat SDF_DATETIME_PATTERN_DATE_COMPRESS;
    private static final String DATETIME_PATTERN_TIME_WITH_COMPRESS = "HHmm";
    public static final FastDateFormat SDF_DATETIME_PATTERN_TIME_COMPRESS;
    private static final String DATETIME_PATTERN_TIME_WITH_SECOND = "HH:mm:ss";
    public static final FastDateFormat SDF_DATETIME_PATTERN_TIME_SECOND;
    private static final String DATETIME_PATTERN_TIME_WITH_NOT_SECOND = "MM-dd";
    public static final FastDateFormat SDF_DATETIME_PATTERN_TIME_NOT_SECOND;
    private static final String DATETIME_PATTERN_TIME_WITH_MIN_NOT_SECOND = "HH:mm";
    public static final FastDateFormat SDF_DATETIME_PATTERN_TIME_MIN_NOT_SECOND;
    private static final String DATETIME_PATTERN_CHINA = "yyyy\u5e74MM\u6708dd\u65e5";
    public static final FastDateFormat SDF_DATETIME_PATTERN_CHINA;
    private static final String MONTH_PATTERN_CHINA = "yyyy\u5e74MM\u6708";
    public static final FastDateFormat SDF_MONTH_PATTERN_CHINA;
    private static final String DATETIME_PATTERN_HOUR = "HH";
    public static final FastDateFormat SDF_DATETIME_PATTERN_HOUR;
    private static final String DATETIME_PATTERN_ISO8601 = "yyyy-MM-dd'T'HH:mm:ssXXX";
    public static final FastDateFormat SDF_DATETIME_PATTERN_ISO8601;

    public static Date getDayStart(Date oDate) {
        DateTime jdt = new DateTime((Object)oDate);
        jdt.withTime(0, 0, 0, 0);
        return jdt.toDate();
    }

    public static Date getYearStart(Integer year) {
        Calendar c = Calendar.getInstance();
        c.set(1, year);
        c.set(6, 1);
        return DateUtil.getDayStart(c.getTime());
    }

    public static Date getDayEnd(Date oDate) {
        DateTime jdt = new DateTime((Object)oDate);
        jdt.withTime(23, 59, 59, 999);
        return jdt.toDate();
    }

    public static Date getYearEnd(Integer year) {
        Calendar c = Calendar.getInstance();
        c.clear();
        c.set(1, year);
        c.roll(6, -1);
        return DateUtil.getDayEnd(c.getTime());
    }

    public static Date getMonthStart(Date oDate) {
        Calendar c = Calendar.getInstance();
        c.setTime(oDate);
        c.add(2, 0);
        c.set(5, 1);
        return DateUtil.getDayStart(c.getTime());
    }

    public static Date getMonthEnd(Date oDate) {
        Calendar c = Calendar.getInstance();
        c.setTime(oDate);
        c.set(5, c.getActualMaximum(5));
        return DateUtil.getDayEnd(c.getTime());
    }

    public static String getLastMonth(Date oDate) {
        Calendar c = Calendar.getInstance();
        c.setTime(oDate);
        c.add(2, -1);
        return SDF_MONTH_PATTERN.format(c.getTime());
    }

    public static int getDayOfWeek(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return cal.get(7) - 1;
    }

    public static int getYear(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return cal.get(1);
    }

    public static String getDayOfWeek(int day) {
        switch (day) {
            case 0: {
                return "SUN";
            }
            case 1: {
                return "MON";
            }
            case 2: {
                return "TUE";
            }
            case 3: {
                return "WED";
            }
            case 4: {
                return "THU";
            }
            case 5: {
                return "FRI";
            }
            case 6: {
                return "SAT";
            }
        }
        return "";
    }

    public static Date addSecond(Date date, Integer second) {
        DateTime jDateTime = new DateTime((Object)date);
        jDateTime.withSecondOfMinute(second.intValue());
        return jDateTime.toDate();
    }

    public static Date addMinutes(Date date, Integer minutes) {
        DateTime jDateTime = new DateTime((Object)date);
        jDateTime.withMinuteOfHour(minutes.intValue());
        return jDateTime.toDate();
    }

    public static Date addHours(Date date, Integer hour) {
        DateTime jDateTime = new DateTime((Object)date);
        jDateTime.withHourOfDay(hour.intValue());
        return jDateTime.toDate();
    }

    public static Date addDay(Date date, Integer day) {
        DateTime jDateTime = new DateTime((Object)date);
        jDateTime.withDayOfYear(day.intValue());
        return jDateTime.toDate();
    }

    public static Date addMonth(Date date, Integer month) {
        DateTime jDateTime = new DateTime((Object)date);
        jDateTime.withMonthOfYear(month.intValue());
        return jDateTime.toDate();
    }

    public static Date addYear(Date date, Integer year) {
        DateTime jDateTime = new DateTime((Object)date);
        jDateTime.withYear(year.intValue());
        return jDateTime.toDate();
    }

    public static final String dateDiff(Date date1, Date date2) {
        Long diff = Math.abs(date1.getTime() - date2.getTime());
        Long day = diff / 86400000L;
        Long hour = diff / 3600000L - day * 24L;
        Long min = diff / 60000L - day * 24L * 60L - hour * 60L;
        Long sec = diff / 1000L - day * 24L * 60L * 60L - hour * 60L * 60L - min * 60L;
        StringBuffer diffStr = new StringBuffer();
        Boolean show = false;
        if (day > 0L) {
            diffStr.append(day);
            diffStr.append("\u5929");
            show = true;
        }
        if (show.booleanValue() || hour > 0L) {
            diffStr.append(hour);
            diffStr.append("\u5c0f\u65f6");
            show = true;
        }
        if (show.booleanValue() || min > 0L) {
            diffStr.append(min);
            diffStr.append("\u5206");
        }
        diffStr.append(sec);
        diffStr.append("\u79d2");
        return diffStr.toString();
    }

    public static final Long dateDiff(Date date1, Date date2, Integer mark) {
        Long diff = Math.abs(date1.getTime() - date2.getTime());
        Long day = diff / 86400000L;
        Long hour = diff / 3600000L - day * 24L;
        Long min = diff / 60000L - day * 24L * 60L - hour * 60L;
        Long sec = diff / 1000L - day * 24L * 60L * 60L - hour * 60L * 60L - min * 60L;
        switch (mark) {
            case 1: {
                return day;
            }
            case 2: {
                return hour;
            }
            case 3: {
                return min;
            }
            case 4: {
                return sec;
            }
        }
        return null;
    }

    public static final Long dateDiffDay(Date date1, Date date2) {
        Long diff = Math.abs(date1.getTime() - date2.getTime());
        Long day = diff / 86400000L;
        return day;
    }

    public static String dayForWeek(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        int day = cal.get(7);
        switch (day) {
            case 1: {
                return "\u5468\u65e5";
            }
            case 2: {
                return "\u5468\u4e00";
            }
            case 3: {
                return "\u5468\u4e8c";
            }
            case 4: {
                return "\u5468\u4e09";
            }
            case 5: {
                return "\u5468\u56db";
            }
            case 6: {
                return "\u5468\u4e94";
            }
            case 7: {
                return "\u5468\u516d";
            }
        }
        return "";
    }

    public static Integer getSeason(Date date) {
        int season = 0;
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        int month = c.get(2);
        switch (month) {
            case 0: 
            case 1: 
            case 2: {
                season = 1;
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                season = 2;
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                season = 3;
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                season = 4;
                break;
            }
        }
        return season;
    }

    static {
        SDF_YEAR_PATTERN = FastDateFormat.getInstance((String)YEAR_PATTERN);
        SDF_MONTH_PATTERN = FastDateFormat.getInstance((String)MONTH_PATTERN);
        SDF_DATE_PATTERN = FastDateFormat.getInstance((String)DATE_PATTERN);
        SDF_DATETIME_PATTERN_NO_SECOND = FastDateFormat.getInstance((String)DATETIME_PATTERN_NO_SECOND);
        SDF_DATETIME_PATTERN = FastDateFormat.getInstance((String)DATETIME_PATTERN);
        SDF_DATETIME_PATTERN_WITH_DOT_FULL = FastDateFormat.getInstance((String)DATETIME_PATTERN_WITH_DOT_FULL);
        SDF_T_DATETIME_PATTERN_NO_SECOND = FastDateFormat.getInstance((String)DATETIME_T_PATTERN_NO_SECOND);
        SDF_T_DATETIME_PATTERN = FastDateFormat.getInstance((String)DATETIME_T_PATTERN);
        SDF_T_DATETIME_PATTERN_WITH_DOT_FULL = FastDateFormat.getInstance((String)DATETIME_T_PATTERN_WITH_DOT_FULL);
        SDF_DATETIME_PATTERN_COMPRESS = FastDateFormat.getInstance((String)DATETIME_PATTERN_WITH_COMPRESS);
        SDF_DATETIME_PATTERN_DATE_COMPRESS = FastDateFormat.getInstance((String)DATETIME_PATTERN_DATE_WITH_COMPRESS);
        SDF_DATETIME_PATTERN_TIME_COMPRESS = FastDateFormat.getInstance((String)DATETIME_PATTERN_TIME_WITH_COMPRESS);
        SDF_DATETIME_PATTERN_TIME_SECOND = FastDateFormat.getInstance((String)DATETIME_PATTERN_TIME_WITH_SECOND);
        SDF_DATETIME_PATTERN_TIME_NOT_SECOND = FastDateFormat.getInstance((String)DATETIME_PATTERN_TIME_WITH_NOT_SECOND);
        SDF_DATETIME_PATTERN_TIME_MIN_NOT_SECOND = FastDateFormat.getInstance((String)DATETIME_PATTERN_TIME_WITH_MIN_NOT_SECOND);
        SDF_DATETIME_PATTERN_CHINA = FastDateFormat.getInstance((String)DATETIME_PATTERN_CHINA);
        SDF_MONTH_PATTERN_CHINA = FastDateFormat.getInstance((String)MONTH_PATTERN_CHINA);
        SDF_DATETIME_PATTERN_HOUR = FastDateFormat.getInstance((String)DATETIME_PATTERN_HOUR);
        SDF_DATETIME_PATTERN_ISO8601 = FastDateFormat.getInstance((String)DATETIME_PATTERN_ISO8601);
    }
}

