/*
 * Decompiled with CFR 0.152.
 */
package org.openoa.base.util;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import org.openoa.base.util.JimuJsonUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetworkUtil {
    private static final Logger log = LoggerFactory.getLogger(NetworkUtil.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isHostConnectable(String host, int port) {
        Socket socket = new Socket();
        try {
            socket.connect(new InetSocketAddress(host, port));
        }
        catch (Exception e) {
            log.debug("isHostConnectable err", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                socket.close();
            }
            catch (IOException e) {
                log.debug("socket.close err", (Throwable)e);
            }
        }
        return true;
    }

    public static List<String> getNetworkIPList() {
        ArrayList<String> list = new ArrayList<String>();
        try {
            Enumeration<NetworkInterface> en = NetworkInterface.getNetworkInterfaces();
            while (en.hasMoreElements()) {
                NetworkInterface intf = en.nextElement();
                Enumeration<InetAddress> enumIpAddr = intf.getInetAddresses();
                while (enumIpAddr.hasMoreElements()) {
                    InetAddress inetAddress = enumIpAddr.nextElement();
                    if (inetAddress.isLoopbackAddress() || inetAddress.isLinkLocalAddress() || !inetAddress.isSiteLocalAddress()) continue;
                    list.add(inetAddress.getHostAddress().toString());
                }
            }
        }
        catch (Exception e) {
            log.error("getNetworkIPList error", (Throwable)e);
        }
        return list;
    }

    public static void main(String[] args) {
        System.out.println(JimuJsonUtil.toJsonString(NetworkUtil.getNetworkIPList()));
    }
}

