/*
 * Decompiled with CFR 0.152.
 */
package org.openoa.base.util;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.openoa.base.adp.FilterDataAdaptor;
import org.openoa.base.constant.enums.FilterDataEnum;
import org.openoa.base.constant.enums.SortTypeEnum;
import org.openoa.base.dto.PageDto;
import org.openoa.base.exception.JiMuBizException;
import org.openoa.base.util.SpringBeanUtils;
import org.openoa.base.vo.PageSortVo;
import org.openoa.base.vo.ResultAndPage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ObjectUtils;

public class PageUtils {
    private static final Logger log = LoggerFactory.getLogger(PageUtils.class);

    public static PageDto getPageDto(Page page) {
        PageDto pageDto = new PageDto();
        pageDto.setPage((int)page.getCurrent());
        pageDto.setPageSize((int)page.getSize());
        pageDto.setTotalCount((int)page.getTotal());
        pageDto.setPageCount((int)page.getPages());
        return pageDto;
    }

    public static <T> Page<T> getPageByPageDto(PageDto pageDto) {
        return PageUtils.buildPage(pageDto);
    }

    public static <T> Page<T> getPageByPageDto(PageDto pageDto, List<PageSortVo> pageSortVos) {
        Page<T> page = PageUtils.buildPage(pageDto);
        if (ObjectUtils.isEmpty(pageSortVos)) {
            return page;
        }
        PageUtils.setOrderByField(page, pageDto, Optional.ofNullable(pageSortVos).orElse(Collections.EMPTY_LIST));
        return page;
    }

    public static <T> Page<T> getPageByPageDto(PageDto pageDto, LinkedHashMap<String, SortTypeEnum> orderFieldMap) {
        Page<T> page = PageUtils.buildPage(pageDto);
        ArrayList<PageSortVo> pageSortVos = new ArrayList<PageSortVo>();
        if (!ObjectUtils.isEmpty(orderFieldMap)) {
            for (Map.Entry<String, SortTypeEnum> entry : orderFieldMap.entrySet()) {
                if (Strings.isNullOrEmpty((String)pageDto.getOrderColumn()) && pageDto.getOrderColumn().equals(entry.getKey())) continue;
                pageSortVos.add(PageSortVo.builder().orderField(entry.getKey()).sortTypeEnum(entry.getValue()).build());
            }
        }
        PageUtils.setOrderByField(page, pageDto, pageSortVos);
        return page;
    }

    public static <T, R> ResultAndPage<R> getResultAndPage(Page<T> page, Function<T, R> mapper) {
        return new ResultAndPage(page.getRecords().stream().map(mapper).collect(Collectors.toList()), PageUtils.getPageDto(page));
    }

    public static <T> ResultAndPage<T> getResultAndPage(Page page) {
        return new ResultAndPage(page.getRecords(), PageUtils.getPageDto(page));
    }

    public static <T> ResultAndPage<T> getResultAndPage(List<T> data, PageDto pageDto) {
        return new ResultAndPage<T>(data, pageDto);
    }

    public static <T> ResultAndPage<T> getResultAndPage(Page page, Map<String, Object> statistics) {
        return new ResultAndPage(page.getRecords(), PageUtils.getPageDto(page), statistics);
    }

    public static <T> ResultAndPage<T> getResultAndPage(Page page, Map<String, Object> statistics, Map<String, String> sortColumnMap) {
        return new ResultAndPage(page.getRecords(), PageUtils.getPageDto(page), statistics, sortColumnMap);
    }

    public static <T> ResultAndPage<T> getResultAndPage(Page page, FilterDataEnum filterDataEnum) {
        FilterDataAdaptor filterDataAdaptor = SpringBeanUtils.getBean(filterDataEnum.getFilterDataService());
        if (!ObjectUtils.isEmpty((Object)filterDataAdaptor)) {
            Map<String, String> sortColumnMap = filterDataAdaptor.filterColumnMap();
            return new ResultAndPage(page.getRecords(), PageUtils.getPageDto(page), null, sortColumnMap);
        }
        return new ResultAndPage(page.getRecords(), PageUtils.getPageDto(page), null);
    }

    public static <T> ResultAndPage<T> getResultAndPage(Page page, Map<String, Object> statistics, FilterDataEnum filterDataEnum) {
        FilterDataAdaptor filterDataAdaptor = SpringBeanUtils.getBean(filterDataEnum.getFilterDataService());
        if (!ObjectUtils.isEmpty((Object)filterDataAdaptor)) {
            Map<String, String> sortColumnMap = filterDataAdaptor.filterColumnMap();
            return new ResultAndPage(page.getRecords(), PageUtils.getPageDto(page), statistics, sortColumnMap);
        }
        return new ResultAndPage(page.getRecords(), PageUtils.getPageDto(page), statistics);
    }

    public static PageDto getPageDtoByVo(Object obj) {
        String objJson = JSON.toJSONString((Object)obj);
        return (PageDto)JSON.parseObject((String)objJson, PageDto.class);
    }

    private static <T> Page<T> buildPage(PageDto pageDto) {
        Page page = new Page(pageDto.getPage() < 1 ? 1L : (long)pageDto.getPage().intValue(), (pageDto.getPageSize() > 200 ? 200 : pageDto.getPageSize()) < 1 ? 1L : (long)pageDto.getPageSize().intValue());
        if (pageDto.getPageSize() == null) {
            pageDto.setPageSize(10);
        }
        if (pageDto.getPage() == null) {
            pageDto.setPage(1);
        }
        return page;
    }

    private static void setOrderByField(Page page, PageDto pageDto, List<PageSortVo> pageSortVos) {
        ArrayList<PageSortVo> pageSortVoList = new ArrayList<PageSortVo>();
        pageSortVoList.addAll(pageSortVos);
        if (!ObjectUtils.isEmpty((Object)pageDto.getOrderColumn()) && !ObjectUtils.isEmpty((Object)pageDto.getOrderType())) {
            pageSortVoList.add(PageSortVo.builder().orderField(pageDto.getOrderColumn()).sortTypeEnum(SortTypeEnum.getSortTypeEnumByCode(pageDto.getOrderType())).build());
        }
        if (ObjectUtils.isEmpty(pageSortVoList)) {
            return;
        }
        ArrayList<String> orderFields = new ArrayList<String>();
        for (int i = 0; i < pageSortVoList.size(); ++i) {
            PageSortVo vo = (PageSortVo)pageSortVoList.get(i);
            if (i < pageSortVoList.size() - 1) {
                orderFields.add(StringUtils.join((Object[])new String[]{vo.getOrderField(), vo.getSortTypeEnum().getMark()}));
                continue;
            }
            orderFields.add(vo.getOrderField());
        }
    }

    public static Integer getPageCount(Integer total, Integer size) {
        return total % size == 0 ? total / size : total / size + 1;
    }

    public static <T> T getPageList(Integer page, Integer pageSize, Integer pageTotalCount, List<?> list) throws JiMuBizException {
        if (page > pageTotalCount) {
            throw new JiMuBizException("999", "wrong page count info");
        }
        if (!page.equals(pageTotalCount)) {
            return (T)list.subList((page - 1) * pageSize, page * pageSize);
        }
        return (T)list.subList((page - 1) * pageSize, list.size());
    }
}

